import javax.swing.JOptionPane;

import csdk.v2.api.application.ApplicationException;
import csdk.v2.api.application.IApplication;
import csdk.v2.api.application.IMessage;
import csdk.v2.api.application.IMessageSender;
import csdk.v2.api.core.ICSDKEnvironment;

/**
 * Hello World do CSDK.
 * 
 * @author Tecgraf
 */
public class HelloWorld implements IApplication {

  /**
   * Construtor padro das aplicaes CSDK.
   * 
   * @param environment ambiente CSDK.
   */
  public HelloWorld(ICSDKEnvironment environment) {
    /*
     * Deveramos guardar a referncia do ambiente para uso posterior, mas como
     * essa aplicao  muito simples, nem isso  necessrio.
     */
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void onApplicationStart() throws ApplicationException {
    JOptionPane.showMessageDialog(null, "Hello World!");
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void onApplicationEnd() throws ApplicationException {
    JOptionPane.showMessageDialog(null, "Bye World!");
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void onAsyncMessageReceived(IMessage message, IMessageSender sender) {
    // No faz nada
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object onSyncMessageReceived(IMessage message, IMessageSender sender) {
    return null;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean canEndApplication() {
    return true;
  }

}
