import javax.swing.JOptionPane;

import csdk.v1_0.api.application.ApplicationException;
import csdk.v1_0.api.application.IApplication;
import csdk.v1_0.api.application.IMessage;
import csdk.v1_0.api.application.IMessageSender;
import csdk.v1_0.api.core.ICSDKEnvironment;

/**
 * Hello World do CSDK.
 * 
 * @author Tecgraf
 */
public class HelloWorld implements IApplication {

  /**
   * Construtor padro das aplicaes CSDK.
   * 
   * @param environment ambiente CSDK.
   */
  public HelloWorld(ICSDKEnvironment environment) {
    /*
     * Deveramos guardar a referncia do ambiente para uso posterior, mas como
     * essa aplicao  muito simples, nem isso  necessrio.
     */
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void onApplicationStart() throws ApplicationException {
    JOptionPane.showMessageDialog(null, "Hello World!");
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void onApplicationEnd() throws ApplicationException {
    JOptionPane.showMessageDialog(null, "Bye World!");
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void onMessageReceived(IMessage message, IMessageSender sender) {
    // Ignora mensagens
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean canEndApplication() {
    return true;
  }

}
