/*
 * Decompiled with CFR 0.152.
 */
package simplecalculator;

import csdk.v2.api.core.ICSDKEnvironment;
import csdk.v2.helper.AbstractCSDKWindowApplication;
import csdk.v2.helper.application.AbstractApplication;
import csdk.v2.helper.application.ApplicationAboutAction;
import csdk.v2.helper.application.ApplicationExitAction;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;

public class SimpleCalculator
extends AbstractCSDKWindowApplication
implements ActionListener {
    public static final int OpMinus = 11;
    public static final int OpMultiply = 12;
    public static final int OpPlus = 13;
    public static final int OpDivide = 15;
    public static final int OpMPlus = 19;
    public static final int OpMClear = 20;
    public static final int OpMR = 21;
    private int Counter;
    private double Result;
    private double Operand;
    private double Mem;
    private boolean DecimalFlag;
    private boolean OperatorKey;
    private int Operator;
    private String Status;
    private final JLabel LabelMem = new JLabel(" ", 4);
    private final JLabel lcdDisplay = new JLabel("0", 4);
    private final JButton button1 = new JButton("1");
    private final JButton button2 = new JButton("2");
    private final JButton button3 = new JButton("3");
    private final JButton button4 = new JButton("4");
    private final JButton button5 = new JButton("5");
    private final JButton button6 = new JButton("6");
    private final JButton button7 = new JButton("7");
    private final JButton button8 = new JButton("8");
    private final JButton button9 = new JButton("9");
    private final JButton button0 = new JButton("0");
    private final JButton buttonMinus = new JButton("-");
    private final JButton buttonMultiply = new JButton("x");
    private final JButton buttonPlus = new JButton("+");
    private final JButton buttonEquals = new JButton("=");
    private final JButton buttonDivide = new JButton("\u00f7");
    private final JButton buttonClear = new JButton("C");
    private final JButton buttonDecimal = new JButton(".");
    private final JButton buttonNegative = new JButton("\u00b1");
    private final JButton buttonMPlus = new JButton("M+");
    private final JButton buttonMClear = new JButton("MC");
    private final JButton buttonMR = new JButton("MR");
    private final JButton buttonPercent = new JButton("%");
    private final JButton buttonOneOverX = new JButton("1/X");
    private final JButton buttonSqr = new JButton("x\u00b2");
    private final JButton buttonSqrRoot = new JButton("sqrt");

    public SimpleCalculator(ICSDKEnvironment csdkInterface) {
        super(csdkInterface);
    }

    private JMenu buildOptionsMenu() {
        JMenu optionsMenu = new JMenu(this.getString("menu.options", new Object[0]));
        optionsMenu.add((Action)new ApplicationExitAction((AbstractApplication)this));
        return optionsMenu;
    }

    private JMenu buildAboutMenu() {
        JMenu aboutMenu = new JMenu(this.getString("menu.help", new Object[0]));
        aboutMenu.add((Action)new ApplicationAboutAction((AbstractApplication)this, (Window)this.getApplicationFrame()));
        return aboutMenu;
    }

    private JMenuBar buildMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.buildOptionsMenu());
        menuBar.add(new JPanel());
        menuBar.add(this.buildAboutMenu());
        return menuBar;
    }

    protected void applicationStarted(JFrame frame) {
        frame.setJMenuBar(this.buildMenuBar());
        frame.getContentPane().add(this.buildPanel());
        frame.setSize(new Dimension(400, 340));
        frame.setResizable(false);
    }

    public boolean canEndApplication() {
        return true;
    }

    public JPanel buildPanel() {
        JPanel main = new JPanel();
        main.setLayout(null);
        main.setSize(420, 350);
        main.setFont(new Font("Helvetica", 0, 12));
        this.lcdDisplay.setBounds(42, 15, 308, 30);
        this.lcdDisplay.setFont(new Font("Helvetica", 0, 20));
        this.lcdDisplay.setForeground(new Color(65280));
        this.lcdDisplay.setOpaque(true);
        this.lcdDisplay.setBackground(Color.black);
        main.add(this.lcdDisplay);
        this.LabelMem.setBounds(350, 15, 20, 30);
        this.LabelMem.setFont(new Font("Helvetica", 0, 16));
        this.LabelMem.setForeground(new Color(65280));
        this.LabelMem.setBackground(new Color(0));
        main.add(this.LabelMem);
        this.button1.addActionListener(this);
        this.button1.setBounds(42, 65, 60, 34);
        this.button1.setFont(new Font("Dialog", 1, 18));
        main.add(this.button1);
        this.button2.addActionListener(this);
        this.button2.setBounds(106, 65, 60, 34);
        this.button2.setFont(new Font("Dialog", 1, 18));
        main.add(this.button2);
        this.button3.addActionListener(this);
        this.button3.setBounds(170, 65, 60, 34);
        this.button3.setFont(new Font("Dialog", 1, 18));
        main.add(this.button3);
        this.button4.addActionListener(this);
        this.button4.setBounds(42, 104, 60, 34);
        this.button4.setFont(new Font("Dialog", 1, 18));
        main.add(this.button4);
        this.button5.addActionListener(this);
        this.button5.setBounds(106, 104, 60, 34);
        this.button5.setFont(new Font("Dialog", 1, 18));
        main.add(this.button5);
        this.button6.addActionListener(this);
        this.button6.setBounds(170, 104, 60, 34);
        this.button6.setFont(new Font("Dialog", 1, 18));
        main.add(this.button6);
        this.button7.addActionListener(this);
        this.button7.setBounds(42, 142, 60, 34);
        this.button7.setFont(new Font("Dialog", 1, 18));
        main.add(this.button7);
        this.button8.addActionListener(this);
        this.button8.setBounds(106, 142, 60, 34);
        this.button8.setFont(new Font("Dialog", 1, 18));
        main.add(this.button8);
        this.button9.addActionListener(this);
        this.button9.setBounds(170, 142, 60, 34);
        this.button9.setFont(new Font("Dialog", 1, 18));
        main.add(this.button9);
        this.button0.addActionListener(this);
        this.button0.setBounds(42, 180, 60, 34);
        this.button0.setFont(new Font("Dialog", 1, 18));
        main.add(this.button0);
        this.buttonDecimal.addActionListener(this);
        this.buttonDecimal.setBounds(106, 180, 60, 34);
        this.buttonDecimal.setFont(new Font("Dialog", 1, 18));
        main.add(this.buttonDecimal);
        this.buttonNegative.addActionListener(this);
        this.buttonNegative.setBounds(170, 180, 60, 34);
        this.buttonNegative.setFont(new Font("Dialog", 1, 18));
        main.add(this.buttonNegative);
        this.buttonMinus.addActionListener(this);
        this.buttonMinus.setBounds(234, 104, 60, 34);
        this.buttonMinus.setFont(new Font("Dialog", 1, 18));
        main.add(this.buttonMinus);
        this.buttonMultiply.addActionListener(this);
        this.buttonMultiply.setBounds(234, 142, 60, 34);
        this.buttonMultiply.setFont(new Font("Dialog", 1, 18));
        main.add(this.buttonMultiply);
        this.buttonPlus.addActionListener(this);
        this.buttonPlus.setBounds(234, 65, 60, 34);
        this.buttonPlus.setFont(new Font("Dialog", 1, 18));
        main.add(this.buttonPlus);
        this.buttonPercent.addActionListener(this);
        this.buttonPercent.setBounds(42, 230, 60, 34);
        this.buttonPercent.setFont(new Font("Dialog", 1, 18));
        main.add(this.buttonPercent);
        this.buttonOneOverX.addActionListener(this);
        this.buttonOneOverX.setBounds(106, 230, 60, 34);
        this.buttonOneOverX.setHorizontalTextPosition(0);
        this.buttonOneOverX.setMargin(new Insets(0, 0, 0, 0));
        this.buttonOneOverX.setFont(new Font("Dialog", 1, 18));
        main.add(this.buttonOneOverX);
        this.buttonSqr.addActionListener(this);
        this.buttonSqr.setBounds(170, 230, 60, 34);
        this.buttonSqr.setFont(new Font("Dialog", 1, 18));
        main.add(this.buttonSqr);
        this.buttonSqrRoot.addActionListener(this);
        this.buttonSqrRoot.setBounds(234, 230, 60, 34);
        this.buttonSqrRoot.setFont(new Font("Dialog", 1, 18));
        this.buttonSqrRoot.setHorizontalTextPosition(0);
        this.buttonSqrRoot.setMargin(new Insets(0, 0, 0, 0));
        main.add(this.buttonSqrRoot);
        this.buttonEquals.addActionListener(this);
        this.buttonEquals.setBounds(309, 230, 60, 34);
        this.buttonEquals.setFont(new Font("Dialog", 1, 18));
        main.add(this.buttonEquals);
        this.buttonDivide.addActionListener(this);
        this.buttonDivide.setBounds(234, 180, 60, 34);
        this.buttonDivide.setFont(new Font("Dialog", 1, 18));
        main.add(this.buttonDivide);
        this.buttonClear.addActionListener(this);
        this.buttonClear.setBounds(309, 65, 60, 34);
        this.buttonClear.setFont(new Font("Dialog", 1, 18));
        this.buttonClear.setForeground(new Color(0xFF0000));
        this.buttonClear.setBackground(new Color(0xC0C0C0));
        main.add(this.buttonClear);
        this.buttonMPlus.addActionListener(this);
        this.buttonMPlus.setBounds(309, 104, 60, 34);
        this.buttonMPlus.setFont(new Font("Dialog", 1, 18));
        this.buttonMPlus.setHorizontalTextPosition(0);
        this.buttonMPlus.setMargin(new Insets(0, 0, 0, 0));
        this.buttonMPlus.setForeground(Color.blue);
        main.add(this.buttonMPlus);
        this.buttonMClear.addActionListener(this);
        this.buttonMClear.setBounds(309, 142, 60, 34);
        this.buttonMClear.setFont(new Font("Dialog", 1, 18));
        this.buttonMClear.setHorizontalTextPosition(0);
        this.buttonMClear.setMargin(new Insets(0, 0, 0, 0));
        this.buttonMClear.setForeground(Color.blue);
        main.add(this.buttonMClear);
        this.buttonMR.addActionListener(this);
        this.buttonMR.setBounds(309, 180, 60, 34);
        this.buttonMR.setFont(new Font("Dialog", 1, 18));
        this.buttonMR.setHorizontalTextPosition(0);
        this.buttonMR.setMargin(new Insets(0, 0, 0, 0));
        this.buttonMR.setForeground(Color.blue);
        main.add(this.buttonMR);
        this.Clicked_Clear();
        return main;
    }

    public void NumericButton(int i) {
        String Display = this.lcdDisplay.getText();
        if (this.OperatorKey) {
            this.Counter = 0;
        }
        ++this.Counter;
        if (Display == "0" || this.Status == "FIRST") {
            Display = "";
        }
        if (this.Counter < 21) {
            Display = Display + String.valueOf(i);
        }
        this.lcdDisplay.setText(Display);
        this.Status = "VALID";
        this.OperatorKey = false;
    }

    public void OperatorButton(int i) {
        try {
            this.Result = new Double(this.lcdDisplay.getText());
        }
        catch (NumberFormatException nfe) {
            return;
        }
        if (!this.OperatorKey) {
            switch (this.Operator) {
                case 13: {
                    this.Result = this.Operand + this.Result;
                    break;
                }
                case 11: {
                    this.Result = this.Operand - this.Result;
                    break;
                }
                case 12: {
                    this.Result *= this.Operand;
                    break;
                }
                case 15: {
                    try {
                        this.Result = this.Operand / this.Result;
                    }
                    catch (ArithmeticException arithmeticException) {
                        // empty catch block
                    }
                    this.validate(this.Result);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown operator (" + this.Operator + ")");
                }
            }
            if (this.Status != "ERROR") {
                this.Status = "FIRST";
                this.Operand = this.Result;
                this.Operator = i;
                this.lcdDisplay.setText(String.valueOf(this.Result));
                this.DecimalFlag = false;
                this.OperatorKey = true;
            } else {
                this.reset();
            }
        }
    }

    public void DecimalButton() {
        String Display = this.lcdDisplay.getText();
        if (this.Status == "FIRST") {
            Display = "0";
        }
        if (!this.DecimalFlag) {
            Display = Display + ".";
        }
        this.lcdDisplay.setText(Display);
        this.DecimalFlag = true;
        this.Status = "VALID";
        this.OperatorKey = false;
    }

    void PercentButton() {
        String Display = this.lcdDisplay.getText();
        if (this.Status != "FIRST" || Display != "0") {
            try {
                this.Result = new Double(this.lcdDisplay.getText());
            }
            catch (NumberFormatException nfe) {
                return;
            }
            this.Result /= 100.0;
            this.lcdDisplay.setText(String.valueOf(this.Result));
            this.Status = "FIRST";
            this.OperatorKey = true;
        }
    }

    void Clicked_Clear() {
        this.reset();
        this.lcdDisplay.setText("0");
    }

    void reset() {
        this.Counter = 0;
        this.Status = "FIRST";
        this.Operand = 0.0;
        this.Result = 0.0;
        this.Operator = 0;
        this.DecimalFlag = false;
        this.OperatorKey = false;
    }

    void PlusMinusButton() {
        String Display = this.lcdDisplay.getText();
        if (this.Status != "FIRST" || Display != "0") {
            try {
                this.Result = new Double(this.lcdDisplay.getText());
            }
            catch (NumberFormatException nfe) {
                return;
            }
            this.Result = -this.Result;
            this.lcdDisplay.setText(String.valueOf(this.Result));
            this.Status = "VALID";
            this.DecimalFlag = true;
        }
    }

    void SqrButton() {
        String Display = this.lcdDisplay.getText();
        if (this.Status != "FIRST" || Display != "0") {
            try {
                this.Result = new Double(this.lcdDisplay.getText());
            }
            catch (NumberFormatException nfe) {
                return;
            }
            this.Result *= this.Result;
            if (this.validate(this.Result)) {
                this.lcdDisplay.setText(String.valueOf(this.Result));
                this.Status = "FIRST";
                this.OperatorKey = true;
            } else {
                this.reset();
            }
        }
    }

    void SqrRootButton() {
        String Display = this.lcdDisplay.getText();
        if (this.Status != "FIRST" || Display != "0") {
            try {
                this.Result = new Double(this.lcdDisplay.getText());
            }
            catch (NumberFormatException nfe) {
                return;
            }
            this.Result = Math.sqrt(this.Result);
            if (this.validate(this.Result)) {
                this.lcdDisplay.setText(String.valueOf(this.Result));
            } else {
                this.reset();
            }
        }
    }

    void OneOverXButton() {
        String Display = this.lcdDisplay.getText();
        if (this.Status != "FIRST" || Display != "0") {
            try {
                this.Result = new Double(this.lcdDisplay.getText());
            }
            catch (NumberFormatException nfe) {
                return;
            }
            this.Result = 1.0 / this.Result;
            this.lcdDisplay.setText(String.valueOf(this.Result));
            this.Status = "FIRST";
            this.OperatorKey = true;
        }
    }

    void MemoryButton(int i) {
        String Display = this.lcdDisplay.getText();
        switch (i) {
            case 19: {
                double temp;
                if ((Display == "0." || Display == "0") && this.Mem == 0.0) {
                    this.LabelMem.setText(" ");
                    break;
                }
                try {
                    temp = new Double(this.lcdDisplay.getText());
                }
                catch (NumberFormatException nfe) {
                    return;
                }
                this.Mem += temp;
                this.LabelMem.setText("M");
                break;
            }
            case 21: {
                this.lcdDisplay.setText(String.valueOf(this.Mem));
                break;
            }
            case 20: {
                this.Mem = 0.0;
                this.LabelMem.setText(" ");
                break;
            }
            default: {
                throw new IllegalStateException("Unknown operator (" + i + ")");
            }
        }
        this.Status = "FIRST";
        this.OperatorKey = true;
        if (this.Mem == 0.0) {
            this.LabelMem.setText(" ");
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src instanceof JButton && (this.Status != "ERROR" || src == this.buttonClear)) {
            if (src == this.button1) {
                this.NumericButton(1);
            }
            if (src == this.button2) {
                this.NumericButton(2);
            }
            if (src == this.button3) {
                this.NumericButton(3);
            }
            if (src == this.button4) {
                this.NumericButton(4);
            }
            if (src == this.button5) {
                this.NumericButton(5);
            }
            if (src == this.button6) {
                this.NumericButton(6);
            }
            if (src == this.button7) {
                this.NumericButton(7);
            }
            if (src == this.button8) {
                this.NumericButton(8);
            }
            if (src == this.button9) {
                this.NumericButton(9);
            }
            if (src == this.button0) {
                this.NumericButton(0);
            }
            if (src == this.buttonMinus) {
                this.OperatorButton(11);
            }
            if (src == this.buttonMultiply) {
                this.OperatorButton(12);
            }
            if (src == this.buttonPlus) {
                this.OperatorButton(13);
            }
            if (src == this.buttonEquals) {
                this.OperatorButton(14);
            }
            if (src == this.buttonDivide) {
                this.OperatorButton(15);
            }
            if (src == this.buttonDecimal) {
                this.DecimalButton();
            }
            if (src == this.buttonPercent) {
                this.PercentButton();
            }
            if (src == this.buttonClear) {
                this.Clicked_Clear();
            }
            if (src == this.buttonNegative) {
                this.PlusMinusButton();
            }
            if (src == this.buttonSqr) {
                this.SqrButton();
            }
            if (src == this.buttonSqrRoot) {
                this.SqrRootButton();
            }
            if (src == this.buttonOneOverX) {
                this.OneOverXButton();
            }
            if (src == this.buttonMPlus) {
                this.MemoryButton(19);
            }
            if (src == this.buttonMClear) {
                this.MemoryButton(20);
            }
            if (src == this.buttonMR) {
                this.MemoryButton(21);
            }
        }
    }

    public boolean keyDown(Event evt, int key) {
        char currchar = (char)key;
        if (currchar == '0') {
            this.NumericButton(0);
        }
        if (currchar == '1') {
            this.NumericButton(1);
        }
        if (currchar == '2') {
            this.NumericButton(2);
        }
        if (currchar == '3') {
            this.NumericButton(3);
        }
        if (currchar == '4') {
            this.NumericButton(4);
        }
        if (currchar == '5') {
            this.NumericButton(5);
        }
        if (currchar == '6') {
            this.NumericButton(6);
        }
        if (currchar == '7') {
            this.NumericButton(7);
        }
        if (currchar == '8') {
            this.NumericButton(8);
        }
        if (currchar == '9') {
            this.NumericButton(9);
        }
        if (currchar == '/') {
            this.OperatorButton(15);
        }
        if (currchar == '*') {
            this.OperatorButton(12);
        }
        if (currchar == '-') {
            this.OperatorButton(11);
        }
        if (currchar == '+') {
            this.OperatorButton(13);
        }
        if (currchar == '=') {
            this.OperatorButton(14);
        }
        if (currchar == '\n') {
            this.OperatorButton(14);
        }
        if (currchar == '.') {
            this.DecimalButton();
        }
        return true;
    }

    private boolean validate(double result) {
        if (Double.isNaN(result)) {
            this.Status = "ERROR";
            this.lcdDisplay.setText(this.getString("text.nan", new Object[0]));
        } else if (Double.isInfinite(this.Result)) {
            this.Status = "ERROR";
            this.lcdDisplay.setText(this.getString("text.infinite", new Object[0]));
        } else {
            return true;
        }
        return false;
    }

    protected void applicationEnded() {
    }
}

