package simplecalculator;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.SwingConstants;

import csdk.v1_0.api.core.ICSDKEnvironment;
import csdk.v1_0.helper.AbstractCSDKWindowApplication;
import csdk.v1_0.helper.application.ApplicationAboutAction;
import csdk.v1_0.helper.application.ApplicationExitAction;

/**
 * Aplicao de calculadora simples.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class SimpleCalculator extends AbstractCSDKWindowApplication implements
  ActionListener {
  /**
   * The following integer values are being set as "final" because they are
   * going to be used for determining what button has been pushed
   */
  public final static int OpMinus = 11;

  /**
   * The following integer values are being set as "final" because they are
   * going to be used for determining what button has been pushed
   */
  public final static int OpMultiply = 12;

  /**
   * The following integer values are being set as "final" because they are
   * going to be used for determining what button has been pushed
   */
  public final static int OpPlus = 13;

  /**
   * The following integer values are being set as "final" because they are
   * going to be used for determining what button has been pushed
   */
  public final static int OpDivide = 15;

  /**
   * The following integer values are being set as "final" because they are
   * going to be used for determining what button has been pushed
   */
  public final static int OpMPlus = 19;

  /**
   * The following integer values are being set as "final" because they are
   * going to be used for determining what button has been pushed
   */
  public final static int OpMClear = 20;

  /**
   * The following integer values are being set as "final" because they are
   * going to be used for determining what button has been pushed
   */
  public final static int OpMR = 21;

  /**
   * Counts the number of digits entered
   */
  private int Counter;

  /**
   * The answer displayed, as well as the second
   */
  private double Result;

  /**
   * The first number entered for an operation
   */
  private double Operand;

  /**
   * The variable which holds whatever value the user
   */
  private double Mem;

  /**
   * The 'flag' that will signify whether or not the
   */
  private boolean DecimalFlag;

  /**
   * The 'flag' that will signify whether or not any
   */
  private boolean OperatorKey;

  /**
   * An integer value to indicate which operator
   */
  private int Operator;

  /**
   * A character to hold the value of the key most
   */
  private char currchar;

  /**
   * String to hold the status of various parts
   */
  private String Status;

  /**
   * This label is just to the left of the Display Label lcdDisplay, and will
   * indicate whether or not a value is being held in the calculator's "memory"
   */
  private JLabel LabelMem = new JLabel(" ", JLabel.RIGHT);

  /**
   * This is the Display Label, which is declared as a label so the user will
   * not be able to enter any text into it to possibly crash the calculator
   */
  private JLabel lcdDisplay = new JLabel("0", JLabel.RIGHT);

  /**
   * This is the declaration of all numeric buttons to be used in the applet
   */
  private JButton button1 = new JButton("1");

  /**
   * This is the declaration of all numeric buttons to be used in the applet
   */
  private JButton button2 = new JButton("2");

  /**
   * This is the declaration of all numeric buttons to be used in the applet
   */
  private JButton button3 = new JButton("3");

  /**
   * This is the declaration of all numeric buttons to be used in the applet
   */
  private JButton button4 = new JButton("4");

  /**
   * This is the declaration of all numeric buttons to be used in the applet
   */
  private JButton button5 = new JButton("5");

  /**
   * This is the declaration of all numeric buttons to be used in the applet
   */
  private JButton button6 = new JButton("6");

  /**
   * This is the declaration of all numeric buttons to be used in the applet
   */
  private JButton button7 = new JButton("7");

  /**
   * This is the declaration of all numeric buttons to be used in the applet
   */
  private JButton button8 = new JButton("8");

  /**
   * This is the declaration of all numeric buttons to be used in the applet
   */
  private JButton button9 = new JButton("9");

  /**
   * This is the declaration of all numeric buttons to be used in the applet
   */
  private JButton button0 = new JButton("0");

  /**
   * This is the declaration of all operation buttons that are used in applet.
   * MPlus, MClear and MR are all memory functions.
   */
  private JButton buttonMinus = new JButton("-");

  /**
   * This is the declaration of all operation buttons that are used in applet.
   * MPlus, MClear and MR are all memory functions.
   */
  private JButton buttonMultiply = new JButton("x");

  /**
   * This is the declaration of all operation buttons that are used in applet.
   * MPlus, MClear and MR are all memory functions.
   */
  private JButton buttonPlus = new JButton("+");

  /**
   * This is the declaration of all operation buttons that are used in applet.
   * MPlus, MClear and MR are all memory functions.
   */
  private JButton buttonEquals = new JButton("=");

  /**
   * This is the declaration of all operation buttons that are used in applet.
   * MPlus, MClear and MR are all memory functions.
   */
  private JButton buttonDivide = new JButton("");

  /**
   * This is the declaration of all operation buttons that are used in applet.
   * MPlus, MClear and MR are all memory functions.
   */
  private JButton buttonClear = new JButton("C");

  /**
   * This is the declaration of all operation buttons that are used in applet.
   * MPlus, MClear and MR are all memory functions.
   */
  private JButton buttonDecimal = new JButton(".");

  /**
   * This is the declaration of all operation buttons that are used in applet.
   * MPlus, MClear and MR are all memory functions.
   */
  private JButton buttonNegative = new JButton("");

  /**
   * This is the declaration of all operation buttons that are used in applet.
   * MPlus, MClear and MR are all memory functions.
   */
  private JButton buttonMPlus = new JButton("M+");

  /**
   * This is the declaration of all operation buttons that are used in applet.
   * MPlus, MClear and MR are all memory functions.
   */
  private JButton buttonMClear = new JButton("MC");

  /**
   * This is the declaration of all operation buttons that are used in applet.
   * MPlus, MClear and MR are all memory functions.
   */
  private JButton buttonMR = new JButton("MR");

  /**
   * This is the declaration of all operation buttons that are used in applet.
   * MPlus, MClear and MR are all memory functions.
   */
  private JButton buttonPercent = new JButton("%");

  /**
   * This is the declaration of all operation buttons that are used in applet.
   * MPlus, MClear and MR are all memory functions.
   */
  private JButton buttonOneOverX = new JButton("1/X");

  /**
   * This is the declaration of all operation buttons that are used in applet.
   * MPlus, MClear and MR are all memory functions.
   */
  private JButton buttonSqr = new JButton("x");

  /**
   * This is the declaration of all operation buttons that are used in applet.
   * MPlus, MClear and MR are all memory functions.
   */
  private JButton buttonSqrRoot = new JButton("sqrt");

  /**
   * Construtor.
   * 
   * @param csdkInterface interface padro para o ambiente CSDK.
   */
  public SimpleCalculator(ICSDKEnvironment csdkInterface) {
    super(csdkInterface);
  }

  /**
   * Montagem do menu de opes.
   * 
   * @return .
   */
  private JMenu buildOptionsMenu() {
    JMenu optionsMenu = new JMenu(getString("menu.options"));
    optionsMenu.add(new ApplicationExitAction(this));
    return optionsMenu;
  }

  /**
   * Montagem do menu de ajuda
   * 
   * @return .
   */
  private JMenu buildAboutMenu() {
    JMenu aboutMenu = new JMenu(getString("menu.help"));
    aboutMenu.add(new ApplicationAboutAction(this, getApplicationFrame()));
    return aboutMenu;
  }

  /**
   * Montagem do menu.
   * 
   * @return .
   */
  private JMenuBar buildMenuBar() {
    JMenuBar menuBar = new JMenuBar();
    menuBar.add(buildOptionsMenu());
    menuBar.add(new JPanel());
    menuBar.add(buildAboutMenu());
    return menuBar;
  }

  /**
   * Montagem do dilogo principal.
   */
  @Override
  protected void applicationStarted(JFrame frame) {
    frame.setJMenuBar(buildMenuBar());
    frame.getContentPane().add(buildPanel());
    frame.setSize(new Dimension(400, 340));
    frame.setResizable(false);
  }

  /**
   * Mtodo que permite sempre ao usurio matar a aplicao.
   * 
   * @return o flag indicativo.
   */
  @Override
  public boolean canEndApplication() {
    return true;
  }

  /**
   * This the only method that is called explicitly -- every other method is
   * called depending on the user's actions.
   * 
   * @return painel
   */
  public JPanel buildPanel() {
    JPanel main = new JPanel();

    //  Allows for configuring a layout with the restraints of a grid or
    //  something similar
    main.setLayout(null);

    //  This will resize the applet to the width and height provided
    main.setSize(420, 350);

    //  This sets the default font to Helvetica, plain, size 12
    main.setFont(new Font("Helvetica", Font.PLAIN, 12));

    /*
     * Display Panel, which appears at the top of the screen. The label is
     * placed and sized with the setBounds(x,y,width,height) method, and the
     * font, foreground color and background color are all set. Then the label
     * is added to the layout of the applet.
     */
    lcdDisplay.setBounds(42, 15, 308, 30);
    lcdDisplay.setFont(new Font("Helvetica", Font.PLAIN, 20));
    lcdDisplay.setForeground(new Color(65280));
    lcdDisplay.setOpaque(true);
    lcdDisplay.setBackground(Color.black);
    main.add(lcdDisplay);

    /*
     * Memory Panel, which appears just to the right of the Display Panel. The
     * label is placed and sized with the setBounds(x,y,width,height) method,
     * and the font, foreground color and background color are all set. Then the
     * label is added to the layout of the applet.
     */
    LabelMem.setBounds(350, 15, 20, 30);
    LabelMem.setFont(new Font("Helvetica", Font.PLAIN, 16));
    LabelMem.setForeground(new Color(65280));
    LabelMem.setBackground(new Color(0));
    main.add(LabelMem);

    /*
     * The following declarations initialize all of the Numberic Buttons that
     * will displayed on the applet.
     * 
     * First, an ActionListener (which will capture events) is added to the
     * button, sending the applet as the argument
     * 
     * Second, the button is placed and sized with the setBounds(x,y,width,
     * height) method.
     * 
     * Then the default font is set for the button, and the button is added to
     * the layout of the applet.
     */
    button1.addActionListener(this);
    button1.setBounds(42, 65, 60, 34);
    button1.setFont(new Font("Dialog", Font.BOLD, 18));
    main.add(button1);

    button2.addActionListener(this);
    button2.setBounds(106, 65, 60, 34);
    button2.setFont(new Font("Dialog", Font.BOLD, 18));
    main.add(button2);

    button3.addActionListener(this);
    button3.setBounds(170, 65, 60, 34);
    button3.setFont(new Font("Dialog", Font.BOLD, 18));
    main.add(button3);

    button4.addActionListener(this);
    button4.setBounds(42, 104, 60, 34);
    button4.setFont(new Font("Dialog", Font.BOLD, 18));
    main.add(button4);

    button5.addActionListener(this);
    button5.setBounds(106, 104, 60, 34);
    button5.setFont(new Font("Dialog", Font.BOLD, 18));
    main.add(button5);

    button6.addActionListener(this);
    button6.setBounds(170, 104, 60, 34);
    button6.setFont(new Font("Dialog", Font.BOLD, 18));
    main.add(button6);

    button7.addActionListener(this);
    button7.setBounds(42, 142, 60, 34);
    button7.setFont(new Font("Dialog", Font.BOLD, 18));
    main.add(button7);

    button8.addActionListener(this);
    button8.setBounds(106, 142, 60, 34);
    button8.setFont(new Font("Dialog", Font.BOLD, 18));
    main.add(button8);

    button9.addActionListener(this);
    button9.setBounds(170, 142, 60, 34);
    button9.setFont(new Font("Dialog", Font.BOLD, 18));
    main.add(button9);

    button0.addActionListener(this);
    button0.setBounds(42, 180, 60, 34);
    button0.setFont(new Font("Dialog", Font.BOLD, 18));
    main.add(button0);

    /*
     * The following declaration and initialization statements set up all of the
     * operation buttons on the applet.
     * 
     * First, an ActionListener is added to each button with the "this" keyword
     * indicating that "this object" (the applet) is being referred to.
     * 
     * Then the button is "reshaped" to a certain coordinate (x and y) as well
     * as new dimensions (width, height).
     * 
     * Then the font is set for that button, and the arguments include: - String
     * value representing the name of the font - a member of Font called BOLD
     * which bolds the text - the size of the font as an integer
     * 
     * Lastly, the button is added to the applet
     */
    buttonDecimal.addActionListener(this);
    buttonDecimal.setBounds(106, 180, 60, 34);
    buttonDecimal.setFont(new Font("Dialog", Font.BOLD, 18));
    main.add(buttonDecimal);

    buttonNegative.addActionListener(this);
    buttonNegative.setBounds(170, 180, 60, 34);
    buttonNegative.setFont(new Font("Dialog", Font.BOLD, 18));
    main.add(buttonNegative);

    buttonMinus.addActionListener(this);
    buttonMinus.setBounds(234, 104, 60, 34);
    buttonMinus.setFont(new Font("Dialog", Font.BOLD, 18));
    main.add(buttonMinus);

    buttonMultiply.addActionListener(this);
    buttonMultiply.setBounds(234, 142, 60, 34);
    buttonMultiply.setFont(new Font("Dialog", Font.BOLD, 18));
    main.add(buttonMultiply);

    buttonPlus.addActionListener(this);
    buttonPlus.setBounds(234, 65, 60, 34);
    buttonPlus.setFont(new Font("Dialog", Font.BOLD, 18));
    main.add(buttonPlus);

    buttonPercent.addActionListener(this);
    buttonPercent.setBounds(42, 230, 60, 34);
    buttonPercent.setFont(new Font("Dialog", Font.BOLD, 18));
    main.add(buttonPercent);

    buttonOneOverX.addActionListener(this);
    buttonOneOverX.setBounds(106, 230, 60, 34);
    buttonOneOverX.setHorizontalTextPosition(SwingConstants.CENTER);
    buttonOneOverX.setMargin(new Insets(0, 0, 0, 0));
    buttonOneOverX.setFont(new Font("Dialog", Font.BOLD, 18));
    main.add(buttonOneOverX);

    buttonSqr.addActionListener(this);
    buttonSqr.setBounds(170, 230, 60, 34);
    buttonSqr.setFont(new Font("Dialog", Font.BOLD, 18));
    main.add(buttonSqr);

    buttonSqrRoot.addActionListener(this);
    buttonSqrRoot.setBounds(234, 230, 60, 34);
    buttonSqrRoot.setFont(new Font("Dialog", Font.BOLD, 18));
    buttonSqrRoot.setHorizontalTextPosition(SwingConstants.CENTER);
    buttonSqrRoot.setMargin(new Insets(0, 0, 0, 0));
    main.add(buttonSqrRoot);

    buttonEquals.addActionListener(this);
    buttonEquals.setBounds(309, 230, 60, 34);
    buttonEquals.setFont(new Font("Dialog", Font.BOLD, 18));
    main.add(buttonEquals);

    buttonDivide.addActionListener(this);
    buttonDivide.setBounds(234, 180, 60, 34);
    buttonDivide.setFont(new Font("Dialog", Font.BOLD, 18));
    main.add(buttonDivide);

    buttonClear.addActionListener(this);
    buttonClear.setBounds(309, 65, 60, 34);
    buttonClear.setFont(new Font("Dialog", Font.BOLD, 18));
    buttonClear.setForeground(new Color(16711680));
    buttonClear.setBackground(new Color(12632256));
    main.add(buttonClear);

    buttonMPlus.addActionListener(this);
    buttonMPlus.setBounds(309, 104, 60, 34);
    buttonMPlus.setFont(new Font("Dialog", Font.BOLD, 18));
    buttonMPlus.setHorizontalTextPosition(SwingConstants.CENTER);
    buttonMPlus.setMargin(new Insets(0, 0, 0, 0));
    buttonMPlus.setForeground(Color.blue);
    main.add(buttonMPlus);

    buttonMClear.addActionListener(this);
    buttonMClear.setBounds(309, 142, 60, 34);
    buttonMClear.setFont(new Font("Dialog", Font.BOLD, 18));
    buttonMClear.setHorizontalTextPosition(SwingConstants.CENTER);
    buttonMClear.setMargin(new Insets(0, 0, 0, 0));
    buttonMClear.setForeground(Color.blue);
    main.add(buttonMClear);

    buttonMR.addActionListener(this);
    buttonMR.setBounds(309, 180, 60, 34);
    buttonMR.setFont(new Font("Dialog", Font.BOLD, 18));
    buttonMR.setHorizontalTextPosition(SwingConstants.CENTER);
    buttonMR.setMargin(new Insets(0, 0, 0, 0));
    buttonMR.setForeground(Color.blue);
    main.add(buttonMR);

    Clicked_Clear(); //calls the Clicked_Clear method (C button)

    return main;
  } //end of calc buildFrame method

  /**
   * This method is called whenever a numeric button (0-9) is pushed.
   * 
   * @param i The pushed buttom
   */
  public void NumericButton(int i) {
    /*
     * Declares a String called Display that will initialize to whatever is
     * currently displayed in the lcdDisplay of the calculator
     */
    String Display = lcdDisplay.getText();

    /*
     * Checks if an operator key has just been pressed, and if it has, then the
     * limit of 20 digits will be reset for the user so that they can enter in
     * up to 20 new numbers
     */
    if (OperatorKey == true) {
      Counter = 0;
    }

    Counter = Counter + 1; //increments the counter

    /*
     * This is a condition to see if the number currently displayed is zero OR
     * an operator key other than +, -,, or / has been pressed.
     */
    if ((Display == "0") || (Status == "FIRST")) {
      Display = ""; //Do not display any new info
    }

    if (Counter < 21) { //if more than 20 numbers are entered

      //  The number just entered is appended to the string currently
      // displayed
      Display = Display + String.valueOf(i);
    }
    lcdDisplay.setText(Display); //sets the text of the lcdDisplay

    //  Label
    Status = "VALID"; //sets the Status string to valid
    OperatorKey = false; //no operator key was pressed
  }

  /**
   * @param i operation
   */
  public void OperatorButton(int i) {

    /*
     * Creates a new Double object with the specific purpose of retaining the
     * string currently on the lcdDisplay label, and then immediately converts
     * that string into a double-precision real number and then gives that
     * number to the variable Result.
     */
    try {
      Result = (new Double(lcdDisplay.getText())).doubleValue();
    }
    catch (NumberFormatException nfe) {
      return;
    }
    //  If no operator key has been pressed
    if ((OperatorKey == false)) {
      switch (Operator) //depending on the operation performed
      {
      /*
       * if the user pressed the addition button, add the two numbers and put
       * them in double Result
       */
        case OpPlus:
          Result = Operand + Result;

          break;

        /*
         * if the user pressed the subtraction button, subtract the two numbers
         * and put them in double Result
         */
        case OpMinus:
          Result = Operand - Result;

          break;

        /*
         * if the user pressed the multiplication button, multiply the two
         * numbers and put them in double Result
         */
        case OpMultiply:
          Result = Result * Operand;

          break;

        /*
         * if the user pressed the division button, check to see if the second
         * number entered is zero to avoid a divide-by-zero exception
         */
        case OpDivide:
          //divide the two numbers and put the
          //answer in double Result
          try {
            Result = Operand / Result;
          }
          catch (ArithmeticException ae) {
            //ignore
          }

          validate(Result);

      }

      //  if after breaking from the switch the Status string is not set
      //  to "ERROR"
      if (Status != "ERROR") {
        Status = "FIRST"; /*
                           * set the Status string to "FIRST" to indicate that a
                           * simple operation was not performed
                           */

        Operand = Result; //Operand holds the value of Result

        Operator = i; /*
                       * the integer value representing the operation being
                       * performed is stored in the integer Operator
                       */

        //  The lcdDisplay label has the value of double Result
        //  displayed
        lcdDisplay.setText(String.valueOf(Result));

        //  The boolean decimal flag is set false, indicating that the
        //  decimal button has not been pressed
        DecimalFlag = false;

        //  The boolean OperatorKey is set true, indicating that a simple
        //  operation has been performed
        OperatorKey = true;

      }
      else {
        reset();
      }
    }
  } //end of OperatorButton method

  /**
   * This is a method that is called whenever the decimal button is pressed.
   */
  public void DecimalButton() {
    //      DisplayError(" "); //Clears the error message field

    /*
     * Declares a String called Display that will initialize to whatever is
     * currently displayed in the lcdDisplay of the calculator
     */
    String Display = lcdDisplay.getText();

    //  if a simple operation was performed successfully
    if (Status == "FIRST") {
      Display = "0"; //set Display string to character 0
    }

    //  If the decimal button has not already been pressed
    if (!DecimalFlag) {
      //  appends a decimal to the string Display
      Display = Display + ".";
    }

    /*
     * calls the setText method of the Label lcdDisplay and sends it the string
     * Display
     */
    lcdDisplay.setText(Display);
    DecimalFlag = true; //the decimal key has been pressed
    Status = "VALID"; /*
                       * Status string indicates a valid operation has been
                       * performed
                       */

    OperatorKey = false; //no operator key has been pressed
  } //end of the DecimalButton method

  /**
   * This method is called whenever the percent button is pressed
   */
  void PercentButton() {
    /*
     * Declares a String called Display that will initialize to whatever is
     * currently displayed in the lcdDisplay of the calculator
     */
    String Display = lcdDisplay.getText();

    /*
     * if the Status string is not set to "FIRST" OR the Display string does not
     * currently hold the value "0"
     */
    if ((Status != "FIRST") || (Display != "0")) {
      /*
       * Creates a new Double object with the specific purpose of retaining the
       * string currently on the lcdDisplay label, and then immediately converts
       * that string into a double-precision real number and then gives that
       * number to the variable Result.
       */
      try {
        Result = (new Double(lcdDisplay.getText())).doubleValue();
      }
      catch (NumberFormatException nfe) {
        return;
      }

      //  divide the double Result by 100, getting the percentage
      Result = Result / 100;

      /*
       * call the setText method of Label lcdDisplay and send it the string that
       * represents the value in Result
       */
      lcdDisplay.setText(String.valueOf(Result));
      Status = "FIRST"; //
      OperatorKey = true; //an operator key has been pressed
    }
  } //end of the PercentButton method

  /**
   * This method is called first when the calculator is initialized with the
   * init() method, and is called every time the "C" button is pressed
   */
  void Clicked_Clear() {
    reset();
    /*
     * calls the setText method of Label lcdDisplay and sends it the character
     * "0"
     */
    lcdDisplay.setText("0");
  }

  /** Logically resets the calculator, without clearing the lcdDisplay */
  void reset() {
    Counter = 0; //sets the counter to zero
    Status = "FIRST"; //sets Status to FIRST
    Operand = 0; //sets Operand to zero
    Result = 0; //sets Result to zero
    Operator = 0; //sets Operator integer to zero

    DecimalFlag = false; //decimal button has not been pressed

    OperatorKey = false; //no operator button has been pressed

  }

  /** This method is called whenever the sign button is pressed */
  void PlusMinusButton() {
    /*
     * Declares a String called Display that will initialize to whatever is
     * currently displayed in the lcdDisplay of the calculator
     */
    String Display = lcdDisplay.getText();

    /*
     * if Status is not set to FIRST and the Display string does not hold the
     * value "0"
     */
    if ((Status != "FIRST") || (Display != "0")) {
      /*
       * Creates a new Double object with the specific purpose of retaining the
       * string currently on the lcdDisplay label, and then immediately converts
       * that string into a double-precision real number and then gives that
       * number to the variable Result.
       */
      try {
        Result = (new Double(lcdDisplay.getText())).doubleValue();
      }
      catch (NumberFormatException nfe) {
        return;
      }
      //  sets the double Result to it's negative value
      Result = -Result;

      /*
       * call the setText method of Label lcdDisplay and send it the string that
       * represents the value in Result
       */
      lcdDisplay.setText(String.valueOf(Result));
      Status = "VALID"; //sets Status string to VALID
      DecimalFlag = true; //a decimal has appeared
    }
  } //end of the PlusMinusButton method

  /** This method is called whenever the square button is pressed */
  void SqrButton() {
    /*
     * Declares a String called Display that will initialize to whatever is
     * currently displayed in the lcdDisplay of the calculator
     */
    String Display = lcdDisplay.getText();

    /*
     * if Status is not set to FIRST and the Display string does not hold the
     * value "0"
     */
    if ((Status != "FIRST") || (Display != "0")) {
      /*
       * Creates a new Double object with the specific purpose of retaining the
       * string currently on the lcdDisplay label, and then immediately converts
       * that string into a double-precision real number and then gives that
       * number to the variable Result.
       */
      try {
        Result = (new Double(lcdDisplay.getText())).doubleValue();
      }
      catch (NumberFormatException nfe) {
        return;
      }

      /*
       * multiply the double Result by itself, effectively squaring the number
       */
      Result = Result * Result;

      if (validate(Result)) {
        /*
         * 
         * call the setText method of Label lcdDisplay and send it the string
         * that represents the value in Result
         */
        lcdDisplay.setText(String.valueOf(Result));

        Status = "FIRST"; //indicates this is the first time

        //  this button has been pressed
        OperatorKey = true; //an operator button has been pressed
      }
      else {
        reset();
      }

    }
  } //end of the SqrButton method

  /** This method is called whenever the square button is pressed */
  void SqrRootButton() {
    /*
     * Declares a String called Display that will initialize to whatever is
     * currently displayed in the lcdDisplay of the calculator
     */
    String Display = lcdDisplay.getText();

    /*
     * if Status is not set to FIRST and the Display string does not hold the
     * value "0"
     */
    if ((Status != "FIRST") || (Display != "0")) {
      /*
       * Creates a new Double object with the specific purpose of retaining the
       * string currently on the lcdDisplay label, and then immediately converts
       * that string into a double-precision real number and then gives that
       * number to the variable Result.
       */
      try {
        Result = (new Double(lcdDisplay.getText())).doubleValue();
      }
      catch (NumberFormatException nfe) {
        return;
      }
      /*
       * Makes a call to the Math class method "sqrt", which produced the square
       * root and stores the value in Result
       */
      Result = Math.sqrt(Result);
      if (validate(Result)) {
        /*
         * call the setText method of Label lcdDisplay and send it the string
         * that represents the value in Result
         */
        lcdDisplay.setText(String.valueOf(Result));
      }
      else {
        reset();
      }
    }
  } //end of the SqrRootButton method

  /** This method is called whenever the OneOverXButton is pressed */
  void OneOverXButton() {
    //        DisplayError(" "); //clears the error message field

    /*
     * Declares a String called Display that will initialize to whatever is
     * currently displayed in the lcdDisplay of the calculator
     */
    String Display = lcdDisplay.getText();

    /*
     * if Status is not set to FIRST and the Display string does not hold the
     * value "0"
     */
    if ((Status != "FIRST") || (Display != "0")) {
      /*
       * Creates a new Double object with the specific purpose of retaining the
       * string currently on the lcdDisplay label, and then immediately converts
       * that string into a double-precision real number and then gives that
       * number to the variable Result.
       */
      try {
        Result = (new Double(lcdDisplay.getText())).doubleValue();
      }
      catch (NumberFormatException nfe) {
        return;
      }

      //  divides one by the double Result
      Result = 1 / Result;

      /*
       * call the setText method of Label lcdDisplay and send it the string that
       * represents the value in Result
       */
      lcdDisplay.setText(String.valueOf(Result));

      Status = "FIRST"; //indicates that this is the first time

      //  this button has been pressed
      OperatorKey = true; //an operator key has been pressed
    }
  } //end of the OneOverXButton method

  /**
   * This method is called whenever one of the three memory buttons is pressed,
   * accepting an integer representing the button pressed as an argument
   * 
   * @param i operation
   */
  void MemoryButton(int i) {
    //      DisplayError(" "); //clears the error message field

    /*
     * Declares a String called Display that will initialize to whatever is
     * currently displayed in the lcdDisplay of the calculator
     */
    String Display = lcdDisplay.getText();

    //  depending on the value sent representing the buttons
    switch (i) {
    /*
     * if the M+ button is pressed, check if the Display string has the value
     * "0." OR just "0", but along with the second condition check if double Mem
     * holds the value zero
     */
      case OpMPlus:

        if (((Display == "0.") || (Display == "0")) && (Mem == 0)) {
          //clears the LabelMem label
          LabelMem.setText(" ");
        }
        else {
          /*
           * Creates a new double variable called temp, which accepts the double
           * value of a new Double object retaining the string currently on the
           * lcdDisplay label, and then immediately converts that string into a
           * double-precision real number
           */
          double temp;
          try {
            temp = (new Double(lcdDisplay.getText())).doubleValue();
          }
          catch (NumberFormatException nfe) {
            return;
          }

          //set the Mem variable with that the sum of what's currently in
          //Mem and the temp variable
          Mem = Mem + temp;

          /*
           * calls the setText method of the Label LabelMem, sending it the
           * character "M"
           */
          LabelMem.setText("M");
        }

        break;

      /*
       * if the MR button is pressed, call the setText method of Label
       * lcdDisplay, sending it the string that represents what the value of Mem
       * is
       */
      case OpMR:
        lcdDisplay.setText(String.valueOf(Mem));

        break;

      /* if the MC button is pressed, set the Mem variable to zero */
      case OpMClear:
        Mem = 0;

        //  clears the LableMem field
        LabelMem.setText(" ");

        break;
    }

    Status = "FIRST"; //indicates that this is first time

    //  button has been pressed
    OperatorKey = true; //an operator button has been pressed

    //  if the Mem variable has the value zero
    if (Mem == 0) {
      LabelMem.setText(" "); //clear the LabelMem field
    }
  } //end of the MemoryButton method

  /***************************************************************************
   * This method is called whenever an action is performed on the applet, *
   * specifically whenever one of the buttons on the applet is pressed *
   **************************************************************************/
  @Override
  public void actionPerformed(ActionEvent event) {
    /*
     * Declares an object named "src" to represent the event.getSource() method.
     * This shortens the code that follows.
     */
    Object src = event.getSource();

    /*
     * Checks to see if the source of the event which src is representing is a
     * Button and can behave like a Button
     */
    if (src instanceof JButton) {
      /*
       * Checks to see if Status string holds the value ERROR OR if the source
       * of the event is the buttonClear ("C") button
       */
      if ((Status != "ERROR") || (src == buttonClear)) {
        /*
         * The following conditions check for numeric buttons that have been
         * pressed, and then called the method NumericButton and send it an
         * integer value depending on the value of the button pressed
         */
        if (src == button1) {
          NumericButton(1);
        }

        if (src == button2) {
          NumericButton(2);
        }

        if (src == button3) {
          NumericButton(3);
        }

        if (src == button4) {
          NumericButton(4);
        }

        if (src == button5) {
          NumericButton(5);
        }

        if (src == button6) {
          NumericButton(6);
        }

        if (src == button7) {
          NumericButton(7);
        }

        if (src == button8) {
          NumericButton(8);
        }

        if (src == button9) {
          NumericButton(9);
        }

        if (src == button0) {
          NumericButton(0);
        }

        /*
         * The following conditions check for operator buttons that have been
         * pressed, and then call the OperatorButton method, sending the
         * corresponding integer value
         */
        if (src == buttonMinus) {
          OperatorButton(11);
        }

        if (src == buttonMultiply) {
          OperatorButton(12);
        }

        if (src == buttonPlus) {
          OperatorButton(13);
        }

        if (src == buttonEquals) {
          OperatorButton(14);
        }

        if (src == buttonDivide) {
          OperatorButton(15);
        }
        /*
         * This condition checks if the decimal button has been pressed, and
         * then calls the DecimalButton method
         */
        if (src == buttonDecimal) {
          DecimalButton();
        }

        /*
         * This condition checks if the percent button has been pressed, and
         * then calls the PercentButton method
         */
        if (src == buttonPercent) {
          PercentButton();
        }

        /*
         * This condition checks if the clear button has been pressed, and then
         * calls the Clicked_Clear method
         */
        if (src == buttonClear) {
          Clicked_Clear();
        }

        /*
         * This condition checks if the Plus Minus Button has been pressed, and
         * then calls the PlusMinusButton method
         */
        if (src == buttonNegative) {
          PlusMinusButton();
        }

        /*
         * This condition checks if the Square Button has been pressed, and then
         * calls the SqrButton method
         */
        if (src == buttonSqr) {
          SqrButton();
        }

        /*
         * This condition checks if the Square Root Button has been pressed, and
         * then calls the SqrRootButton method
         */
        if (src == buttonSqrRoot) {
          SqrRootButton();
        }

        /*
         * This condition checks if the One over X Button has been pressed, and
         * then calls the OneOverXButton method
         */
        if (src == buttonOneOverX) {
          OneOverXButton();
        }

        /*
         * These conditions checks to see if any of the Memory Buttons have been
         * pressed, and then calls the MemoryButton method and sends them the
         * corresponding integer values
         */
        if (src == buttonMPlus) {
          MemoryButton(19);
        }

        if (src == buttonMClear) {
          MemoryButton(20);
        }

        if (src == buttonMR) {
          MemoryButton(21);
        }
      }
    }
  } //end of actionPerformed method

  /**
   * 
   * The following method handles all of the key events that occurs when a user
   * enters values from the keyboard. It accepts an Event object and an integer
   * representing the key pressed as arguments.
   * 
   * It should be noted that in order to accept keys entered to the lcdDisplay,
   * the applet must be in focus.
   * 
   * @param evt event
   * @param key key
   * @return flag
   */
  public boolean keyDown(Event evt, int key) {
    //  assigns key value to currchar through typecasting key to a character
    currchar = (char) key;

    /*
     * The following conditions check to see if a number key has been pressed
     * and calls the NumericButton method, sending it the appropriate integer as
     * an argument
     */
    if (currchar == '0') {
      NumericButton(0);
    }

    if (currchar == '1') {
      NumericButton(1);
    }

    if (currchar == '2') {
      NumericButton(2);
    }

    if (currchar == '3') {
      NumericButton(3);
    }

    if (currchar == '4') {
      NumericButton(4);
    }

    if (currchar == '5') {
      NumericButton(5);
    }

    if (currchar == '6') {
      NumericButton(6);
    }

    if (currchar == '7') {
      NumericButton(7);
    }

    if (currchar == '8') {
      NumericButton(8);
    }

    if (currchar == '9') {
      NumericButton(9);
    }

    /*
     * The following conditions check to see if any of the operator keys which
     * are on the number pad have been pressed. It then calls the OperatorButton
     * method, sending it the appropriate integer value as an argument.
     * 
     * It should be noted that the main functions checked for are those on the
     * number pad, but if they are pressed at other occurences on the keyboard,
     * they are still accepted.
     */

    if (currchar == '/') {
      OperatorButton(15);
    }

    if (currchar == '*') {
      OperatorButton(12);
    }

    if (currchar == '-') {
      OperatorButton(11);
    }

    if (currchar == '+') {
      OperatorButton(13);
    }

    if (currchar == '=') {
      OperatorButton(14);
    }

    //  This condition is different from the others because it tests for
    // the
    //  Enter key being pressed, and this is pre-built into the Event evt
    //  object
    if (currchar == Event.ENTER) {
      OperatorButton(14);
    }

    /*
     * This checks for the decimal key being pressed, either on the number pad
     * or the period key, and calls the DecimalButton method.
     */
    if (currchar == '.') {
      DecimalButton();
    }

    return true; //indicate successful operation
  }

  /**
   * Validate the boolean, setting the error status and showing an error in case
   * result is NaN or infinite
   * 
   * @param result The result to be evaluated
   * @return true if the result is valid, false otherwise
   */
  private boolean validate(double result) {
    if (Double.isNaN(result)) {
      Status = "ERROR";
      lcdDisplay.setText(getString("text.nan"));
    }
    else if (Double.isInfinite(Result)) {
      Status = "ERROR";
      lcdDisplay.setText(getString("text.infinite"));
    }
    else {
      return true;
    }

    return false;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void applicationEnded() {
    // No faz nada.
  }

}
