/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_2.server.states;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc_1_2.common.logic.ErrorCode;
import tecgraf.ftc_1_2.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_2.server.Session;
import tecgraf.ftc_1_2.server.states.GetOperationState;
import tecgraf.ftc_1_2.server.states.State;

public final class SetPositionState
implements State {
    private InternalState currentState = InternalState.INITIAL;
    private long position;
    private ErrorCode errorCode;
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");

    public SetPositionState() {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Estado para definir a posi\u00e7\u00e3o de um arquivo.");
        }
    }

    @Override
    public boolean read(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case INITIAL: {
                buffer.limit(PrimitiveTypeSize.LONG.getSize());
                try {
                    if (channel.read(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Erro ao ler do canal.");
                    }
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.position = buffer.getLong();
                buffer.clear();
                this.currentState = InternalState.POSITION_READ;
                FileChannel fileChannel = session.getFileChannel();
                try {
                    fileChannel.position(this.position);
                    this.errorCode = ErrorCode.OK;
                    break;
                }
                catch (IOException e) {
                    this.errorCode = ErrorCode.FAILURE;
                }
            }
        }
        return true;
    }

    @Override
    public boolean write(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case POSITION_READ: {
                buffer.limit(PrimitiveTypeSize.BYTE.getSize());
                buffer.put(this.errorCode.getCode());
                buffer.flip();
                try {
                    if (channel.write(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Erro ao escrever no canal.");
                    }
                    return false;
                }
                buffer.clear();
                this.currentState = InternalState.ERROR_CODE_SENT;
                session.setCurrentState(new GetOperationState());
                if (!logger.isLoggable(Level.FINER)) break;
                logger.finer("C\u00f3digo " + (Object)((Object)this.errorCode) + " enviado.");
            }
        }
        return true;
    }

    private static enum InternalState {
        INITIAL,
        POSITION_READ,
        ERROR_CODE_SENT;

    }
}

