/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_2.server.states.v1_1;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc_1_2.common.logic.ErrorCode;
import tecgraf.ftc_1_2.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_2.server.Session;
import tecgraf.ftc_1_2.server.states.State;
import tecgraf.ftc_1_2.server.states.v1_1.GetOperationState;

public final class SetSizeState
implements State {
    private InternalState currentState = InternalState.INITIAL;
    private ErrorCode errorCode;
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");

    public SetSizeState() {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Estado que altera o tamanho de um arquivo.");
        }
    }

    @Override
    public boolean read(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case INITIAL: {
                buffer.limit(PrimitiveTypeSize.LONG.getSize());
                try {
                    if (channel.read(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                long size = buffer.getLong();
                buffer.clear();
                this.currentState = InternalState.SIZE_READ;
                FileChannel fileChannel = session.getFileChannel();
                try {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Atual tamanho: " + fileChannel.size());
                        logger.finer("Novo tamanho: " + size);
                    }
                    if (size > fileChannel.size()) {
                        ByteBuffer src = ByteBuffer.wrap(new byte[]{0});
                        long currentPosition = fileChannel.position();
                        fileChannel.position(size - 1L);
                        fileChannel.write(src);
                        fileChannel.position(currentPosition);
                    } else {
                        fileChannel.truncate(size);
                    }
                    this.errorCode = ErrorCode.OK;
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.errorCode = ErrorCode.FAILURE;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case SIZE_READ: {
                buffer.limit(PrimitiveTypeSize.BYTE.getSize());
                buffer.put(this.errorCode.getCode());
                buffer.flip();
                try {
                    if (channel.write(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    boolean bl = false;
                    return bl;
                }
                finally {
                    buffer.clear();
                }
                this.currentState = InternalState.ERROR_CODE_SENT;
                session.setCurrentState(new GetOperationState());
                if (!logger.isLoggable(Level.FINER)) break;
                logger.finer("C\u00f3digo " + (Object)((Object)this.errorCode) + " enviado.");
            }
        }
        return true;
    }

    private static enum InternalState {
        INITIAL,
        SIZE_READ,
        ERROR_CODE_SENT;

    }
}

