package tecgraf.ftc_1_2.server;

import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileChannel;

import tecgraf.ftc_1_2.common.exception.FailureException;
import tecgraf.ftc_1_2.common.exception.PermissionException;
import tecgraf.ftc_1_2.utils.Utils;

/**
 * Classe que implementa um provedor de arquivos (FileChannel) para o servidor
 * de arquivos.
 * 
 * @author Tecgraf
 */
public class DefaultFileProvider implements FileProvider {

  /**
   * {@inheritDoc}
   */
  @Override
  public FileChannel createFileChannel(Object requester, byte[] fileId,
    boolean readOnly) throws PermissionException, FailureException {
    String absolutePath;
    try {
      absolutePath = new String(fileId, Utils.CHARSET_ENCODING);
    }
    catch (UnsupportedEncodingException e) {
      throw new FailureException(e);
    }
    String mode = "r";
    if (!readOnly) {
      mode += "w";
    }
    RandomAccessFile raf;
    try {
      raf = new RandomAccessFile(absolutePath, mode);
    }
    catch (FileNotFoundException e) {
      return null;
    }
    return raf.getChannel();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isLocked(Object requester, byte[] fileId) {
    return false;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void fileChannelClosed(Object requester, byte[] fileId,
    ChannelClosedReason reason) {
    try {
      String absolutePath = new String(fileId, Utils.CHARSET_ENCODING);
      System.out.println("O arquivo " + absolutePath + " foi fechado.");
      System.out.println("razo: " + reason.toString());
    }
    catch (UnsupportedEncodingException e) {
      e.printStackTrace();
    }
  }

}
