/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_2.server.states;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc_1_2.common.logic.ErrorCode;
import tecgraf.ftc_1_2.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_2.server.Session;
import tecgraf.ftc_1_2.server.states.State;
import tecgraf.ftc_1_2.server.states.ValidateKeyState;

public class VersionHandshakeState
implements State {
    private InternalState currentState = InternalState.INITIAL;
    private ErrorCode errorCode;
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");

    public VersionHandshakeState() {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Estado que lida com o handshake inicial.");
        }
    }

    @Override
    public boolean read(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case INITIAL: {
                buffer.limit(PrimitiveTypeSize.BYTE.getSize());
                try {
                    if (channel.read(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Erro ao ler do canal.");
                    }
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                if (buffer.get(0) != 0) {
                    session.setCurrentState(new tecgraf.ftc_1_2.server.states.v1_1.ValidateKeyState());
                    return true;
                }
                this.currentState = InternalState.FTC_1_1_PROTOCOL_CHECKED;
            }
            case FTC_1_1_PROTOCOL_CHECKED: {
                buffer.limit(PrimitiveTypeSize.INTEGER.getSize());
                try {
                    if (channel.read(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Erro ao ler do canal.");
                    }
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                int protocolId = buffer.getInt();
                buffer.clear();
                if (protocolId != 4609091) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Cliente enviou uma mensagem invalida.");
                    }
                    this.currentState = InternalState.VERSION_RECEIVED;
                    this.errorCode = ErrorCode.FAILURE;
                    return true;
                }
                this.currentState = InternalState.PROTOCOL_ID_RECEIVED;
            }
            case PROTOCOL_ID_RECEIVED: {
                buffer.limit(PrimitiveTypeSize.INTEGER.getSize());
                try {
                    if (channel.read(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Erro ao ler do canal.");
                    }
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                buffer.get();
                byte major_version = buffer.get();
                byte minor_version = buffer.get();
                byte patch_version = buffer.get();
                buffer.clear();
                this.currentState = InternalState.VERSION_RECEIVED;
                if (logger.isLoggable(Level.FINER)) {
                    logger.fine("Cliente conectado utilizando versao: " + major_version + "." + minor_version + "." + patch_version);
                }
                if (major_version == 1 && minor_version == 2) {
                    this.errorCode = ErrorCode.OK;
                    break;
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.fine("Versao nao suportada por este servidor");
                }
                this.errorCode = ErrorCode.INVALID_VERSION;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case VERSION_RECEIVED: {
                buffer.limit(PrimitiveTypeSize.BYTE.getSize());
                buffer.put(this.errorCode.getCode());
                buffer.flip();
                try {
                    if (channel.write(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Erro ao ler do canal.");
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    buffer.clear();
                }
                this.currentState = InternalState.ERROR_CODE_SENT;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("C\u00f3digo " + (Object)((Object)this.errorCode) + " enviado.");
                }
                if (this.errorCode == ErrorCode.OK) {
                    session.setCurrentState(new ValidateKeyState());
                    break;
                }
                return false;
            }
        }
        return true;
    }

    private static enum InternalState {
        INITIAL,
        FTC_1_1_PROTOCOL_CHECKED,
        PROTOCOL_ID_RECEIVED,
        VERSION_RECEIVED,
        ERROR_CODE_SENT;

    }
}

