/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_2.server.states.v1_1;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc_1_2.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_2.server.Session;
import tecgraf.ftc_1_2.server.states.State;
import tecgraf.ftc_1_2.server.states.v1_1.GetOperationState;

public final class GetSizeState
implements State {
    private InternalState currentState = InternalState.INITIAL;
    private long size;
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");

    public GetSizeState() {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Estado de obten\u00e7\u00e3o do tamanho do arquivo.");
        }
    }

    @Override
    public boolean read(Session session) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case INITIAL: {
                FileChannel fileChannel = session.getFileChannel();
                try {
                    this.size = fileChannel.size();
                }
                catch (IOException e) {
                    this.size = -1L;
                    session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                }
                this.currentState = InternalState.SIZE_READ;
            }
            case SIZE_READ: {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Enviando o tamanho do arquivo " + this.size);
                }
                buffer.limit(PrimitiveTypeSize.LONG.getSize());
                buffer.putLong(this.size);
                buffer.flip();
                try {
                    if (channel.write(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                    boolean bl = false;
                    return bl;
                }
                finally {
                    buffer.clear();
                }
                this.currentState = InternalState.SIZE_WRITTEN;
                session.setCurrentState(new GetOperationState());
            }
        }
        return true;
    }

    private static enum InternalState {
        INITIAL,
        SIZE_READ,
        SIZE_WRITTEN;

    }
}

