/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_3.server;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import tecgraf.ftc_1_3.common.exception.InvalidArraySize;

public final class AccessKey {
    private static final String PRNG_ALGORITHM = "SHA1PRNG";
    public static final int KEY_SIZE = 16;
    private byte[] key;

    public AccessKey() {
        SecureRandom secureRandom = null;
        try {
            secureRandom = SecureRandom.getInstance(PRNG_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            secureRandom = new SecureRandom();
        }
        this.key = new byte[16];
        secureRandom.nextBytes(this.key);
    }

    public AccessKey(byte[] bytes) throws InvalidArraySize {
        if (bytes.length < 16) {
            throw new InvalidArraySize();
        }
        this.key = new byte[16];
        System.arraycopy(bytes, 0, this.key, 0, 16);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        AccessKey accessKey = (AccessKey)obj;
        return Arrays.equals(this.key, accessKey.key);
    }

    public int hashCode() {
        return Arrays.hashCode(this.key);
    }

    public String toString() {
        return Arrays.toString(this.key);
    }

    byte[] getBytes() {
        byte[] bytes = new byte[16];
        System.arraycopy(this.key, 0, bytes, 0, 16);
        return bytes;
    }
}

