/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_3.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc_1_3.common.exception.InvalidArraySize;
import tecgraf.ftc_1_3.common.logic.ErrorCode;
import tecgraf.ftc_1_3.server.AccessKey;
import tecgraf.ftc_1_3.server.ChannelClosedReason;
import tecgraf.ftc_1_3.server.FileChannelAccessInfo;
import tecgraf.ftc_1_3.server.FileChannelRequestInfo;
import tecgraf.ftc_1_3.server.FileProvider;
import tecgraf.ftc_1_3.server.FileServerConfig;
import tecgraf.ftc_1_3.server.FileServerConfigImpl;
import tecgraf.ftc_1_3.server.FileServerExceptionHandler;
import tecgraf.ftc_1_3.server.LogFormatter;
import tecgraf.ftc_1_3.server.MaxChannelRequestsException;
import tecgraf.ftc_1_3.server.Session;
import tecgraf.ftc_1_3.server.states.CloseState;
import tecgraf.ftc_1_3.server.states.State;

public final class FileServer {
    private FileProvider fileProvider;
    private volatile boolean wasStopped;
    protected boolean initialized = false;
    private Selector selector;
    private Map<AccessKey, FileChannelRequestInfo> channels;
    private FileServerConfig config = null;
    private ServerSocketChannel serverChannel = null;
    SelectionKey serverKey = null;
    private long lastTimeoutCheck = 0L;
    private FileServerExceptionHandler exceptionHandler = null;
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");
    public static final boolean PLATAFORM_HAS_TRANSFERTO_BUG = System.getProperty("os.name").contains("Linux") && System.getProperty("sun.arch.data.model").contains("32") && !System.getProperty("java.version").contains("1.7.0");

    public FileServer(FileProvider fileProvider) throws IOException {
        this.fileProvider = fileProvider;
        this.config = new FileServerConfigImpl();
        this.channels = new HashMap<AccessKey, FileChannelRequestInfo>();
        logger.setUseParentHandlers(false);
        for (Handler handler : logger.getHandlers()) {
            logger.removeHandler(handler);
        }
    }

    public FileProvider getFileProvider() {
        return this.fileProvider;
    }

    public boolean serverSetup() {
        if (!this.initialized) {
            try {
                logger.setLevel(this.config.getLoglevel());
                FileHandler logOutputFile = new FileHandler(this.config.getOutputLogFilename(), true);
                logOutputFile.setFormatter(new LogFormatter());
                logger.addHandler(logOutputFile);
                this.serverChannel = ServerSocketChannel.open();
                this.serverChannel.configureBlocking(false);
                ServerSocket serverSocket = this.serverChannel.socket();
                serverSocket.bind(new InetSocketAddress(this.config.getHostName(), this.config.getPort()));
                this.selector = Selector.open();
                this.serverKey = this.serverChannel.register(this.selector, 16);
            }
            catch (Exception e) {
                this.exceptionRaised(e);
                return false;
            }
            this.initialized = true;
        }
        return this.initialized;
    }

    public void dispatch() {
        if (!this.serverSetup()) {
            return;
        }
        while (!this.wasStopped) {
            block7: {
                try {
                    int selectedKeyCount = this.selector.select(this.config.getSelectTimeout());
                    this.checkTimedOutConnections();
                    if (selectedKeyCount == 0) {
                    }
                    break block7;
                }
                catch (IOException e) {
                    this.exceptionRaised(e);
                }
                continue;
            }
            Iterator<SelectionKey> selectedKeys = this.selector.selectedKeys().iterator();
            while (selectedKeys.hasNext()) {
                SelectionKey key = selectedKeys.next();
                selectedKeys.remove();
                if (!key.isValid()) continue;
                if (this.serverKey.equals(key)) {
                    if (!key.isAcceptable()) continue;
                    this.accept(key);
                    continue;
                }
                this.read(key);
                if (!key.isValid() || !key.isWritable()) continue;
                this.write(key);
            }
        }
        this.shutdownConnections();
    }

    private void printKeyAddress(SelectionKey key) {
        Session session = (Session)key.attachment();
        if (session == null) {
            return;
        }
        logger.finest("Address: " + session.getChannel().socket().getRemoteSocketAddress());
    }

    private void checkTimedOutConnections() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastTimeoutCheck < this.config.getSelectTimeout()) {
            return;
        }
        this.lastTimeoutCheck = currentTime;
        Set<SelectionKey> keys = this.selector.keys();
        for (SelectionKey key : keys) {
            long test;
            Session session = (Session)key.attachment();
            if (session == null || (test = currentTime - session.getLastActivity()) <= this.config.getClientTimeout()) continue;
            logger.finer("Conexao fechada por inatividade.");
            this.stopConnection(key, session, ChannelClosedReason.CHANNEL_TIMEOUT);
        }
        Set<Map.Entry<AccessKey, FileChannelRequestInfo>> channelSet = this.channels.entrySet();
        Iterator<Map.Entry<AccessKey, FileChannelRequestInfo>> iter = channelSet.iterator();
        while (iter.hasNext()) {
            Map.Entry<AccessKey, FileChannelRequestInfo> entry = iter.next();
            FileChannelRequestInfo requestInfo = entry.getValue();
            long test = currentTime - requestInfo.getCreationTime();
            if (test <= this.config.getChannelRequestTimeout()) continue;
            logger.finer("Canal removido porque n\u00e3o foi consumido dentro do tempo");
            iter.remove();
        }
    }

    private void shutdownConnections() {
        logger.finer("Fechando conexoes.");
        for (SelectionKey key : this.selector.keys()) {
            Session session = (Session)key.attachment();
            this.stopConnection(key, session, ChannelClosedReason.SERVER_SHUTDOWN);
        }
        this.serverChannel = null;
    }

    public void stop() {
        this.wasStopped = true;
    }

    public FileChannelAccessInfo createFileChannelInfo(Object requester, byte[] fileId) throws InvalidArraySize, MaxChannelRequestsException {
        return this.createFileChannelInfo(requester, fileId, null);
    }

    public FileChannelAccessInfo createFileChannelInfo(Object requester, byte[] fileId, byte[] accessKey) throws InvalidArraySize, MaxChannelRequestsException {
        return this.createFileChannelInfo(requester, fileId, accessKey, true);
    }

    public FileChannelAccessInfo createFileChannelInfo(Object requester, byte[] fileId, byte[] accessKey, boolean useTransferTo) throws InvalidArraySize, MaxChannelRequestsException {
        if (this.channels.size() + 1 > this.config.getMaxChannelRequests()) {
            throw new MaxChannelRequestsException("Limite maximo de canais atingido");
        }
        AccessKey key = accessKey != null ? new AccessKey(accessKey) : new AccessKey();
        FileChannelRequestInfo fileChannelIinfo = new FileChannelRequestInfo(requester, fileId);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Criando novo FileChannelInfo: " + Arrays.toString(fileId));
        }
        fileChannelIinfo.useTransferTo(useTransferTo);
        this.channels.put(key, fileChannelIinfo);
        return new FileChannelAccessInfo(this.config.getHostName(), this.serverChannel.socket().getLocalPort(), key.getBytes(), fileId);
    }

    public FileChannelRequestInfo getFileChannelInfo(AccessKey accessKey) {
        if (this.config.isTestMode()) {
            return this.channels.get(accessKey);
        }
        return this.channels.remove(accessKey);
    }

    public void exceptionRaised(Exception e, byte[] fileId) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.exceptionRaised(e, fileId);
        }
    }

    public void exceptionRaised(Exception e) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.exceptionRaised(e);
        }
    }

    private void accept(SelectionKey key) {
        block11: {
            SocketChannel socketChannel;
            block10: {
                ServerSocketChannel serverChannel = (ServerSocketChannel)key.channel();
                socketChannel = null;
                try {
                    while ((socketChannel = serverChannel.accept()) != null) {
                        socketChannel.configureBlocking(false);
                        Session session = new Session(socketChannel, this);
                        session.markLastActivity();
                        socketChannel.register(this.selector, 5, session);
                        int clients = this.selector.keys().size() - 1;
                        if (clients > this.config.getMaxClients()) {
                            if (logger.isLoggable(Level.FINER)) {
                                logger.finer("N\u00famero m\u00e1ximo de clientes atingido.");
                            }
                            session.setCurrentState(new CloseState(ErrorCode.MAX_CLIENTS_REACHED));
                            break;
                        }
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Cliente conectado:" + socketChannel.socket().getRemoteSocketAddress());
                            logger.fine("Numero de clientes:" + clients);
                        }
                        if (this.config.acceptMaxPossible()) continue;
                        break;
                    }
                    return;
                }
                catch (IOException e) {
                    this.exceptionRaised(e);
                }
                catch (OutOfMemoryError e) {
                    if (!logger.isLoggable(Level.WARNING)) break block10;
                    logger.warning("N\u00e3o h\u00e1 recursos suficientes. A Conex\u00e3o sera fechada.");
                }
            }
            try {
                if (socketChannel != null) {
                    socketChannel.close();
                }
            }
            catch (IOException ioe) {
                if (!logger.isLoggable(Level.WARNING)) break block11;
                logger.warning("Erro ao tentar fechar a conex\u00e3o.");
            }
        }
    }

    private void read(SelectionKey key) {
        Session session = (Session)key.attachment();
        try {
            State currentState = session.getCurrentState();
            if (currentState == null || !currentState.read(session)) {
                this.stopConnection(key, session, ChannelClosedReason.CHANNEL_ERROR);
            }
        }
        catch (Exception e) {
            this.exceptionRaised(e, session.getFileChannelInfo().getFileId());
            this.stopConnection(key, session, ChannelClosedReason.CHANNEL_ERROR);
        }
    }

    private void write(SelectionKey key) {
        Session session = (Session)key.attachment();
        try {
            State currentState = session.getCurrentState();
            if (currentState == null || !currentState.write(session)) {
                this.stopConnection(key, session, ChannelClosedReason.CHANNEL_ERROR);
            }
        }
        catch (Exception e) {
            this.exceptionRaised(e, session.getFileChannelInfo().getFileId());
            this.stopConnection(key, session, ChannelClosedReason.CHANNEL_ERROR);
        }
    }

    private void stopConnection(SelectionKey key, Session session, ChannelClosedReason reason) {
        if (session != null) {
            session.close(reason);
        } else {
            try {
                key.channel().close();
            }
            catch (IOException e) {
                logger.finer("Erro ao fechar conex\u00e3o.");
            }
        }
        key.attach(null);
        key.cancel();
    }

    public FileServerConfig getConfig() {
        return this.config;
    }

    public void setConfig(FileServerConfig config) {
        this.config = config;
    }

    public FileServerExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(FileServerExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }
}

