/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_3.server.states;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc_1_3.common.logic.ErrorCode;
import tecgraf.ftc_1_3.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_3.server.ChannelClosedReason;
import tecgraf.ftc_1_3.server.Session;
import tecgraf.ftc_1_3.server.states.State;

public final class CloseState
implements State {
    private ErrorCode errorCode = ErrorCode.FAILURE;
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");

    public CloseState() {
        this(ErrorCode.FAILURE);
    }

    public CloseState(ErrorCode error) {
        this.errorCode = error;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Estado de fechamento.");
        }
    }

    @Override
    public boolean read(Session session) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(Session session) {
        if (session.closeFileChannel(ChannelClosedReason.REQUESTED_BY_CLIENT)) {
            this.errorCode = ErrorCode.OK;
        }
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        buffer.limit(PrimitiveTypeSize.BYTE.getSize());
        buffer.put(this.errorCode.getCode());
        buffer.flip();
        try {
            if (channel.write(buffer) > 0) {
                session.markLastActivity();
            }
        }
        catch (IOException e) {
            session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
            boolean bl = false;
            return bl;
        }
        finally {
            buffer.clear();
        }
        try {
            channel.close();
        }
        catch (IOException e) {
            session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
        }
        session.setCurrentState(null);
        return true;
    }
}

