/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_3.server.states;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc_1_3.common.logic.ErrorCode;
import tecgraf.ftc_1_3.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_3.server.Session;
import tecgraf.ftc_1_3.server.states.GetOperationState;
import tecgraf.ftc_1_3.server.states.State;

public final class GetPositionState
implements State {
    private InternalState currentState;
    private long position;
    private ErrorCode errorCode = ErrorCode.FAILURE;
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");

    public GetPositionState() {
        this.currentState = InternalState.INITIAL;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Estado de obten\u00e7\u00e3o de posi\u00e7\u00e3o.");
        }
    }

    @Override
    public boolean read(Session session) {
        return true;
    }

    @Override
    public boolean write(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case INITIAL: {
                FileChannel fileChannel = session.getFileChannel();
                try {
                    this.position = fileChannel.position();
                    this.errorCode = ErrorCode.OK;
                }
                catch (IOException e) {
                    this.position = -1L;
                    session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                }
                this.currentState = InternalState.POSITION_READ;
            }
            case POSITION_READ: {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Enviando a posi\u00e7\u00e3o do arquivo " + this.position);
                }
                if (this.errorCode.equals((Object)ErrorCode.OK)) {
                    buffer.limit(PrimitiveTypeSize.BYTE.getSize() + PrimitiveTypeSize.LONG.getSize());
                    buffer.put(this.errorCode.getCode());
                    buffer.putLong(this.position);
                } else {
                    buffer.limit(PrimitiveTypeSize.BYTE.getSize());
                    buffer.put(this.errorCode.getCode());
                }
                buffer.flip();
                try {
                    if (channel.write(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    return false;
                }
                buffer.clear();
                this.currentState = InternalState.POSITION_WRITTEN;
                session.setCurrentState(new GetOperationState());
            }
        }
        return true;
    }

    private static enum InternalState {
        INITIAL,
        POSITION_READ,
        POSITION_WRITTEN;

    }
}

