package tecgraf.ftc_1_3.server;

import java.io.UnsupportedEncodingException;

import tecgraf.ftc_1_3.utils.Utils;

/**
 * Classe que implementa um handler padrao de excees para o servidor de
 * arquivos
 * 
 * @author Tecgraf
 */
public class DefaultFileServerExceptionHandler implements
  FileServerExceptionHandler {

  /**
   * {@inheritDoc}
   */
  @Override
  public void exceptionRaised(Exception e, byte[] fileId) {
    try {
      System.out.println("ExceptionRaised: " + e.getClass().getSimpleName());
      String absolutePath = new String(fileId, Utils.CHARSET_ENCODING);
      System.out.println(String.format("fileId = %s", absolutePath));
      e.printStackTrace();

    }
    catch (UnsupportedEncodingException e1) {
      e1.printStackTrace();
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void exceptionRaised(Exception e) {
    System.out.println("ExceptionRaised: " + e.getClass().getSimpleName());
    e.printStackTrace();
  }
}
