/*
 * $Id: FileChannelAccessInfo.java 78415 2008-06-13 14:06:00Z rodrigoh $
 */
package tecgraf.ftc_1_3.server;

/**
 * Representa informaes sobre o acesso a um canal de dados.
 *
 * @author Tecgraf/PUC-Rio
 */
public final class FileChannelAccessInfo {
  /**
   * A mquina do servidor de arquivos.
   */
  private String host;
  /**
   * A porta do servidor de arquivos.
   */
  private int port;
  /**
   * A chave de acesso, usada na autorizao de conexes.
   */
  private byte[] accessKey;
  /**
   * O identificador do arquivo.
   */
  private byte[] fileId;

  /**
   * Cria informaes sobre o acesso a um canal de dados.
   *
   * @param host A mquina do servidor de arquivos.
   * @param port A porta do servidor de arquivos.
   * @param accessKey A chave de acesso.
   * @param fileId O identificador do arquivo.
   */
  FileChannelAccessInfo(String host, int port, byte[] accessKey, byte[] fileId) {
    this.host = host;
    this.port = port;
    this.accessKey = accessKey;
    this.fileId = fileId;
  }

  /**
   * Obtm a mquina do servidor de arquivos.
   *
   * @return A mquina do servidor de arquivos.
   */
  public String getHost() {
    return this.host;
  }

  /**
   * Obtm a porta do servidor de arquivos.
   *
   * @return A porta do servidor de arquivos.
   */
  public int getPort() {
    return this.port;
  }

  /**
   * Obtm a chave de acesso.
   *
   * @return A chave de acesso.
   */
  public byte[] getAccessKey() {
    return this.accessKey;
  }

  /**
   * Obtm o identificador do arquivo.
   *
   * @return O identificador do arquivo.
   */
  public byte[] getFileIdentifier() {
    return this.fileId;
  }
}
