package tecgraf.ftc_1_3.server;

import java.util.logging.Formatter;
import java.util.logging.LogRecord;

/**
 * Classe responsvel por formatar as mensagens de sada do servidor FTC.
 */
public class LogFormatter extends Formatter {

  /**
   * Construtor
   */
  public LogFormatter() {
    super();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String format(LogRecord record) {

    StringBuffer sb = new StringBuffer();

    sb.append("[");
    sb.append(record.getMillis());
    sb.append("] ");

    //sb.append(record.getLevel().getName());
    //sb.append(": ");

    sb.append(formatMessage(record));
    sb.append("\n");

    return sb.toString();
  }

}
