/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_4.client;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import tecgraf.ftc_1_4.client.IRemoteDataChannel;
import tecgraf.ftc_1_4.common.exception.DataChannelException;
import tecgraf.ftc_1_4.common.exception.FailureException;
import tecgraf.ftc_1_4.common.exception.FileLockedException;
import tecgraf.ftc_1_4.common.exception.InvalidProtocolVersionException;
import tecgraf.ftc_1_4.common.exception.MaxClientsReachedException;
import tecgraf.ftc_1_4.common.exception.PermissionException;
import tecgraf.ftc_1_4.common.exception.UnexpectedProtocolMessage;
import tecgraf.ftc_1_4.common.logic.ErrorCode;
import tecgraf.ftc_1_4.common.logic.Operation;
import tecgraf.ftc_1_4.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_4.common.logic.ResultMessage;
import tecgraf.ftc_1_4.utils.ByteBufferUtils;

public final class RemoteDataChannel
implements IRemoteDataChannel {
    public static final int MAX_IDENTIFIER_SIZE = 65535;
    public static final int MAX_KEY_SIZE = 255;
    public static final int MIN_BUFFER_SIZE = 65535;
    private String host;
    private int port;
    private byte[] key;
    private boolean writable;
    private SocketChannel channel;
    private ByteBuffer buffer;
    private int bufferSize = 0x100000;
    private ResultMessage lastResultMessage;
    private short operations = 0;

    public RemoteDataChannel(boolean writable, String host, int port, byte[] key) {
        if (host == null) {
            throw new IllegalArgumentException("Par\u00e2metro host n\u00e3o pode ser nulo");
        }
        if (host.isEmpty()) {
            throw new IllegalArgumentException("Par\u00e2metro host n\u00e3o pode ser vazio");
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Par\u00e2metro port fora da faixa permitida: " + port);
        }
        if (key == null) {
            throw new IllegalArgumentException("Par\u00e2metro key n\u00e3o pode ser nulo");
        }
        if (key.length == 0 || key.length > 255) {
            throw new IllegalArgumentException("Tamanho do par\u00e2metro key inv\u00e1lido: " + key.length);
        }
        this.host = host;
        this.port = port;
        this.key = key;
        this.writable = writable;
    }

    @Override
    public void open() throws PermissionException, FileNotFoundException, FailureException, MaxClientsReachedException, InvalidProtocolVersionException {
        if (this.isOpen()) {
            throw new FailureException("O canal j\u00e1 est\u00e1 aberto!");
        }
        try {
            InetSocketAddress address = new InetSocketAddress(this.host, this.port);
            if (address.isUnresolved()) {
                throw new FailureException("Endere\u00e7o n\u00e3o resolvido: " + this.host);
            }
            this.channel = SocketChannel.open(address);
            this.channel.socket().setTcpNoDelay(true);
        }
        catch (IOException e) {
            throw new FailureException(e);
        }
        this.buffer = ByteBuffer.allocate(this.bufferSize);
        this.protocolVersionHandshake();
        this.authenticate();
        ResultMessage retMesg = null;
        try {
            Operation operation = this.writable ? Operation.OPEN_READ_WRITE : Operation.OPEN_READ_ONLY;
            this.buffer.clear();
            ByteBufferUtils.writeByte(this.buffer, this.channel, operation.getCode());
            retMesg = this.readResultMessage();
            if (retMesg.success.booleanValue()) {
                this.operations = ByteBufferUtils.readShort(this.buffer, this.channel);
            }
        }
        catch (IOException e) {
            this.release();
            throw new FailureException(e);
        }
        catch (UnexpectedProtocolMessage e) {
            this.release();
            throw new FailureException(e);
        }
        if (!retMesg.success.booleanValue()) {
            this.release();
            if (retMesg.code.equals((Object)ErrorCode.FILE_NOT_FOUND)) {
                throw new FileNotFoundException("O arquivo n\u00e3o existe.");
            }
            if (retMesg.code.equals((Object)ErrorCode.NO_PERMISSION)) {
                throw new PermissionException("Sem permiss\u00e3o para abrir o arquivo.");
            }
            if (retMesg.code.equals((Object)ErrorCode.FAILURE)) {
                throw new FailureException("Falha no servidor ao tentar abrir o arquivo.");
            }
            throw new IllegalStateException("C\u00f3digo de erro inv\u00e1lido " + retMesg);
        }
    }

    private void protocolVersionHandshake() throws FailureException, PermissionException, MaxClientsReachedException, InvalidProtocolVersionException {
        ResultMessage retMesg = null;
        try {
            long idAndVersion = 4609091L;
            idAndVersion <<= 32;
            int major = 1;
            int minor = 4;
            int patch = 0;
            this.buffer.clear();
            ByteBufferUtils.writeLong(this.buffer, this.channel, idAndVersion |= (long)(major << 16 | minor << 8 | patch));
            retMesg = this.readResultMessage();
        }
        catch (IOException e) {
            this.release();
            throw new FailureException(e);
        }
        catch (UnexpectedProtocolMessage e) {
            this.release();
            throw new FailureException(e);
        }
        if (!retMesg.success.booleanValue()) {
            this.release();
            if (retMesg.code.equals((Object)ErrorCode.INVALID_VERSION)) {
                throw new InvalidProtocolVersionException("Servidor n\u00e3o suporta esta vers\u00e3o do protocolo.");
            }
            if (retMesg.code.equals((Object)ErrorCode.MAX_CLIENTS_REACHED)) {
                throw new MaxClientsReachedException("N\u00famero m\u00e1ximo de clientes no servidor atingido.");
            }
            if (retMesg.code.equals((Object)ErrorCode.FAILURE)) {
                throw new FailureException("Falha ao negociar protocolo com o servidor.");
            }
            throw new IllegalStateException("C\u00f3digo de erro inv\u00e1lido " + (Object)((Object)retMesg.code));
        }
    }

    private void authenticate() throws FailureException, PermissionException, MaxClientsReachedException {
        ResultMessage retMesg = null;
        try {
            this.buffer.clear();
            ByteBufferUtils.writeBytesByteSize(this.buffer, this.channel, this.key);
            retMesg = this.readResultMessage();
        }
        catch (IOException e) {
            this.release();
            throw new FailureException(e);
        }
        catch (UnexpectedProtocolMessage e) {
            this.release();
            throw new FailureException(e);
        }
        if (!retMesg.success.booleanValue()) {
            this.release();
            if (retMesg.code.equals((Object)ErrorCode.INVALID_KEY)) {
                throw new PermissionException("Chave de acesso inv\u00e1lida.");
            }
            if (retMesg.code.equals((Object)ErrorCode.FAILURE)) {
                throw new FailureException("Falha no servidor ao tentar se autenticar com a chave fornecida.");
            }
            throw new IllegalStateException("C\u00f3digo de erro inv\u00e1lido " + (Object)((Object)retMesg.code));
        }
    }

    @Override
    public boolean isOpen() {
        if (this.channel == null) {
            return false;
        }
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.checkIsOpen();
        ResultMessage retMesg = null;
        try {
            ByteBufferUtils.writeByte(this.buffer, this.channel, Operation.CLOSE.getCode());
            retMesg = this.readResultMessage();
            if (!retMesg.success.booleanValue()) {
                throw new IOException("Falha no fechamento do canal do arquivo.");
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (UnexpectedProtocolMessage e) {
            throw new IOException(e);
        }
        finally {
            this.release();
        }
    }

    private ResultMessage readResultMessage() throws IOException, UnexpectedProtocolMessage {
        this.lastResultMessage = new ResultMessage();
        this.buffer.clear();
        this.buffer.limit(PrimitiveTypeSize.BYTE.getSize());
        do {
            if (this.channel.read(this.buffer) != -1) continue;
            throw new IOException("channel closed");
        } while (this.buffer.hasRemaining());
        this.buffer.flip();
        byte result = this.buffer.get();
        this.buffer.clear();
        if (result != 1 && result != 0) {
            throw new UnexpectedProtocolMessage("Mensagem invalida");
        }
        this.lastResultMessage.success = result == 0;
        if (this.lastResultMessage.success.booleanValue()) {
            return this.lastResultMessage;
        }
        this.buffer.limit(PrimitiveTypeSize.BYTE.getSize() + PrimitiveTypeSize.SHORT.getSize());
        do {
            if (this.channel.read(this.buffer) != -1) continue;
            throw new IOException("channel closed");
        } while (this.buffer.hasRemaining());
        this.buffer.flip();
        byte code = this.buffer.get();
        char msgSize = this.buffer.getChar();
        this.buffer.clear();
        ErrorCode errorCode = ErrorCode.valueOf(code);
        ErrorCode errorCode2 = this.lastResultMessage.code = errorCode == null ? ErrorCode.UNKNOWN_ERROR : errorCode;
        if (msgSize <= '\u0000') {
            this.lastResultMessage.message = "";
            return this.lastResultMessage;
        }
        this.buffer.limit(msgSize);
        do {
            if (this.channel.read(this.buffer) != -1) continue;
            throw new IOException("channel closed");
        } while (this.buffer.hasRemaining());
        this.buffer.flip();
        byte[] msgArray = new byte[msgSize];
        this.buffer.get(msgArray);
        this.buffer.clear();
        this.lastResultMessage.message = new String(msgArray);
        return this.lastResultMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release() {
        try {
            this.channel.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.buffer = null;
            this.channel = null;
        }
    }

    @Override
    public void setSize(long size) throws PermissionException, FailureException {
        this.checkIsOpen();
        if (size < 0L) {
            throw new IllegalArgumentException("Parametro size n\u00e3o pode ser negativo: " + size);
        }
        if (!this.writable) {
            throw new PermissionException("Arquivo foi aberto somente para a leitura.");
        }
        this.buffer.put(Operation.SET_SIZE.getCode());
        try {
            ByteBufferUtils.writeLong(this.buffer, this.channel, PrimitiveTypeSize.BYTE.getSize(), size);
            ResultMessage retMesg = this.readResultMessage();
            if (!retMesg.success.booleanValue()) {
                switch (retMesg.code) {
                    case UNSUPPORTED_OPERATION: {
                        throw new UnsupportedOperationException("Opera\u00e7\u00e3o n\u00e3o suportada.");
                    }
                    case READ_ONLY: {
                        throw new PermissionException("Arquivo foi aberto somente para a leitura.");
                    }
                }
                throw new FailureException("Falha ao alterar o tamanho do arquivo.");
            }
        }
        catch (IOException e) {
            this.release();
            throw new FailureException(e);
        }
        catch (UnexpectedProtocolMessage e) {
            this.release();
            throw new FailureException(e);
        }
    }

    @Override
    public long getPosition() throws FailureException {
        this.checkIsOpen();
        try {
            ByteBufferUtils.writeByte(this.buffer, this.channel, Operation.GET_POSITION.getCode());
            ResultMessage retMesg = this.readResultMessage();
            if (!retMesg.success.booleanValue()) {
                switch (retMesg.code) {
                    case UNSUPPORTED_OPERATION: {
                        throw new UnsupportedOperationException("Opera\u00e7\u00e3o n\u00e3o suportada.");
                    }
                }
                throw new FailureException("Falha ao ler posi\u00e7\u00e3o do arquivo.");
            }
            long pos = ByteBufferUtils.readLong(this.buffer, this.channel);
            return pos;
        }
        catch (IOException e) {
            this.release();
            throw new FailureException(e);
        }
        catch (UnexpectedProtocolMessage e) {
            this.release();
            throw new FailureException(e);
        }
    }

    @Override
    public void setPosition(long position) throws FailureException {
        this.checkIsOpen();
        if (position < 0L) {
            throw new IllegalArgumentException("Parametro position n\u00e3o pode ser negativo: " + position);
        }
        try {
            this.buffer.put(Operation.SET_POSITION.getCode());
            ByteBufferUtils.writeLong(this.buffer, this.channel, PrimitiveTypeSize.BYTE.getSize(), position);
            ResultMessage retMesg = this.readResultMessage();
            if (!retMesg.success.booleanValue()) {
                switch (retMesg.code) {
                    case UNSUPPORTED_OPERATION: {
                        throw new UnsupportedOperationException("Opera\u00e7\u00e3o n\u00e3o suportada.");
                    }
                }
                throw new FailureException("Falha ao alterar a posi\u00e7\u00e3o do arquivo.");
            }
        }
        catch (IOException e) {
            this.release();
            throw new FailureException(e);
        }
        catch (UnexpectedProtocolMessage e) {
            this.release();
            throw new FailureException(e);
        }
    }

    @Override
    public long getSize() throws FailureException {
        this.checkIsOpen();
        try {
            ByteBufferUtils.writeByte(this.buffer, this.channel, Operation.GET_SIZE.getCode());
            ResultMessage retMesg = this.readResultMessage();
            if (!retMesg.success.booleanValue()) {
                switch (retMesg.code) {
                    case UNSUPPORTED_OPERATION: {
                        throw new UnsupportedOperationException("Opera\u00e7\u00e3o n\u00e3o suportada.");
                    }
                }
                throw new FailureException("Falha ao ler tamanho do arquivo");
            }
            long size = ByteBufferUtils.readLong(this.buffer, this.channel);
            return size;
        }
        catch (IOException e) {
            this.release();
            throw new FailureException(e);
        }
        catch (UnexpectedProtocolMessage e) {
            this.release();
            throw new FailureException(e);
        }
    }

    @Override
    public int read(ByteBuffer dest) throws FailureException {
        return this.read(dest, -1L);
    }

    @Override
    public int read(ByteBuffer dest, long remotePosition) throws FailureException {
        this.checkIsOpen();
        if (dest == null) {
            throw new IllegalArgumentException("Parametro target n\u00e3o pode ser nulo.");
        }
        if (remotePosition < -1L) {
            throw new IllegalArgumentException("Parametro remotePosition n\u00e3o pode ser menor que -1: " + remotePosition);
        }
        this.buffer.put(Operation.READ.getCode());
        this.buffer.putLong(remotePosition);
        this.buffer.putLong(dest.remaining());
        this.buffer.flip();
        try {
            this.channel.write(this.buffer);
        }
        catch (IOException e) {
            throw new FailureException(e);
        }
        finally {
            this.buffer.clear();
        }
        int originalLimit = dest.limit();
        int totalBytesRead = 0;
        while (dest.hasRemaining()) {
            try {
                int missingBytes;
                ResultMessage retMesg = this.readResultMessage();
                if (!retMesg.success.booleanValue()) {
                    switch (retMesg.code) {
                        case END_OF_FILE: {
                            if (totalBytesRead == 0) {
                                return -1;
                            }
                            return totalBytesRead;
                        }
                        case UNSUPPORTED_OPERATION: {
                            throw new UnsupportedOperationException("Opera\u00e7\u00e3o n\u00e3o suportada.");
                        }
                    }
                    throw new FailureException("Falha ao tentar ler arquivo");
                }
                int preChunkSize = ByteBufferUtils.readInt(this.buffer, this.channel);
                long chunkSize = (long)preChunkSize & 0xFFFFFFFFL;
                int limit = chunkSize < (long)(missingBytes = originalLimit - dest.position()) ? (int)chunkSize : missingBytes;
                dest.limit(dest.position() + limit);
                int bytesRead = 0;
                int readCount = 0;
                while ((long)bytesRead < chunkSize) {
                    readCount = this.channel.read(dest);
                    if (readCount < 0) {
                        throw new FailureException("Falha ao tentar ler dados do canal");
                    }
                    bytesRead += readCount;
                }
                dest.limit(originalLimit);
                totalBytesRead += bytesRead;
            }
            catch (IOException e) {
                this.release();
                throw new FailureException(e);
            }
            catch (UnexpectedProtocolMessage e) {
                this.release();
                throw new FailureException(e);
            }
        }
        return totalBytesRead;
    }

    @Override
    public int write(ByteBuffer source) throws PermissionException, FailureException, FileLockedException {
        return this.write(source, -1L);
    }

    @Override
    public int write(ByteBuffer source, long remotePosition) throws PermissionException, FailureException, FileLockedException {
        this.checkIsOpen();
        if (source == null) {
            throw new IllegalArgumentException("Parametro source n\u00e3o pode ser nulo");
        }
        if (!this.writable) {
            throw new PermissionException("Arquivo foi aberto somente para a leitura.");
        }
        if (remotePosition < -1L) {
            throw new IllegalArgumentException("Parametro remotePosition n\u00e3o pode ser menor que -1: " + remotePosition);
        }
        this.buffer.put(Operation.WRITE.getCode());
        this.buffer.putLong(remotePosition);
        ResultMessage retMesg = null;
        try {
            ByteBufferUtils.writeLong(this.buffer, this.channel, PrimitiveTypeSize.BYTE.getSize() + PrimitiveTypeSize.LONG.getSize(), source.remaining());
            retMesg = this.readResultMessage();
        }
        catch (IOException e) {
            this.release();
            throw new FailureException(e);
        }
        catch (UnexpectedProtocolMessage e) {
            this.release();
            throw new FailureException(e);
        }
        if (!retMesg.success.booleanValue()) {
            switch (retMesg.code) {
                case UNSUPPORTED_OPERATION: {
                    throw new UnsupportedOperationException("Opera\u00e7\u00e3o n\u00e3o suportada.");
                }
                case FILE_LOCKED: {
                    throw new FileLockedException("Arquivo reservado para outro usu\u00e1rio.");
                }
                case READ_ONLY: {
                    throw new PermissionException("Arquivo esta aberto somente para leitura.");
                }
            }
            throw new FailureException("Falha ao tentar escrever no arquivo");
        }
        try {
            return this.channel.write(source);
        }
        catch (IOException e) {
            throw new FailureException(e);
        }
    }

    @Override
    public long transferTo(long remotePosition, long count, WritableByteChannel dest) throws FailureException, IOException {
        this.checkIsOpen();
        if (dest == null) {
            throw new IllegalArgumentException("Parametro dest n\u00e3o pode ser nulo");
        }
        if (remotePosition < -1L) {
            throw new IllegalArgumentException("Parametro remotePosition n\u00e3o pode menor que -1: " + remotePosition);
        }
        if (count < 0L) {
            throw new IllegalArgumentException("Parametro count n\u00e3o pode ser negativo" + count);
        }
        this.buffer.put(Operation.READ.getCode());
        this.buffer.putLong(remotePosition);
        this.buffer.putLong(count);
        this.buffer.flip();
        try {
            this.channel.write(this.buffer);
        }
        catch (IOException e) {
            this.release();
            throw e;
        }
        this.buffer.clear();
        long bytesWrittenTotal = 0L;
        long currentChunkSize = 0L;
        int chunkReadBytes = 0;
        int bytesRead = 0;
        while (bytesWrittenTotal < count) {
            try {
                ResultMessage retMesg = this.readResultMessage();
                if (!retMesg.success.booleanValue()) {
                    switch (retMesg.code) {
                        case END_OF_FILE: {
                            if (bytesWrittenTotal == 0L) {
                                return -1L;
                            }
                            return bytesWrittenTotal;
                        }
                        case UNSUPPORTED_OPERATION: {
                            throw new UnsupportedOperationException("Opera\u00e7\u00e3o n\u00e3o suportada.");
                        }
                    }
                    throw new FailureException("Falha ao tentar ler arquivo");
                }
                int preChunkSize = ByteBufferUtils.readInt(this.buffer, this.channel);
                currentChunkSize = (long)preChunkSize & 0xFFFFFFFFL;
            }
            catch (IOException e) {
                this.release();
                throw new FailureException(e);
            }
            catch (UnexpectedProtocolMessage e) {
                this.release();
                throw new FailureException(e);
            }
            chunkReadBytes = 0;
            while ((long)chunkReadBytes < currentChunkSize) {
                this.buffer.clear();
                this.buffer.limit((int)(currentChunkSize - (long)chunkReadBytes));
                try {
                    bytesRead = this.channel.read(this.buffer);
                    if (bytesRead < 0) {
                        throw new FailureException("Falha ao tentar ler dados do canal");
                    }
                    this.buffer.flip();
                    dest.write(this.buffer);
                }
                catch (IOException e) {
                    this.buffer.clear();
                    throw new FailureException(e);
                }
                bytesWrittenTotal += (long)bytesRead;
                chunkReadBytes += bytesRead;
            }
            this.buffer.clear();
        }
        this.buffer.clear();
        return bytesWrittenTotal;
    }

    @Override
    public long transferFrom(ReadableByteChannel source, long remotePosition, long count) throws IOException, DataChannelException {
        this.checkIsOpen();
        if (!this.writable) {
            throw new PermissionException("Arquivo foi aberto somente para a leitura.");
        }
        if (source == null) {
            throw new IllegalArgumentException("Parametro source n\u00e3o pode ser nulo");
        }
        if (remotePosition < -1L) {
            throw new IllegalArgumentException("Parametro remotePosition n\u00e3o pode ser menor que -1: " + remotePosition);
        }
        if (count < 0L) {
            throw new IllegalArgumentException("Parametro count n\u00e3o pode ser negativo: " + count);
        }
        this.buffer.put(Operation.WRITE.getCode());
        this.buffer.putLong(remotePosition);
        ResultMessage retMesg = null;
        try {
            ByteBufferUtils.writeLong(this.buffer, this.channel, PrimitiveTypeSize.BYTE.getSize() + PrimitiveTypeSize.LONG.getSize(), count);
            retMesg = this.readResultMessage();
        }
        catch (IOException e) {
            this.buffer.clear();
            throw e;
        }
        if (!retMesg.success.booleanValue()) {
            switch (retMesg.code) {
                case FILE_LOCKED: {
                    throw new FileLockedException("Arquivo reservado para outro usu\u00e1rio.");
                }
                case READ_ONLY: {
                    throw new PermissionException("Arquivo foi aberto somente para leitura.");
                }
            }
            throw new FailureException("Falha ao tentar transferir dados para o canal");
        }
        long bytesReadTotal = 0L;
        while (bytesReadTotal < count) {
            this.buffer.clear();
            if ((long)this.buffer.limit() > count - bytesReadTotal) {
                this.buffer.limit((int)(count - bytesReadTotal));
            }
            try {
                int bytesRead = source.read(this.buffer);
                if (bytesRead == -1) break;
                bytesReadTotal += (long)bytesRead;
                this.buffer.flip();
                while (this.buffer.hasRemaining()) {
                    if (this.channel.write(this.buffer) >= 0) continue;
                    this.buffer.clear();
                    throw new FailureException("Falha ao escreve no canal remoto");
                }
            }
            catch (IOException e) {
                this.buffer.clear();
                throw e;
            }
        }
        this.buffer.clear();
        return bytesReadTotal;
    }

    @Override
    public void keepAlive() throws FailureException {
        this.checkIsOpen();
        try {
            ByteBufferUtils.writeByte(this.buffer, this.channel, Operation.KEEP_ALIVE.getCode());
            ResultMessage retMesg = this.readResultMessage();
            if (!retMesg.success.booleanValue()) {
                throw new FailureException("Erro na opera\u00e7\u00e3o Keep Alive");
            }
        }
        catch (IOException e) {
            this.release();
            throw new FailureException(e);
        }
        catch (UnexpectedProtocolMessage e) {
            this.release();
            throw new FailureException(e);
        }
    }

    public void setBufferSize(int bufferSize) {
        if (bufferSize > 65535) {
            this.bufferSize = bufferSize;
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public short supportedOperations() {
        return this.operations;
    }

    @Override
    public long remaining() throws IOException, DataChannelException {
        return this.getSize() - this.getPosition();
    }

    @Override
    public long skip(long bytes) throws IOException, DataChannelException {
        this.setPosition(this.getPosition() + bytes);
        return bytes;
    }

    public ResultMessage getLastResultMessage() {
        return this.lastResultMessage;
    }

    private void checkIsOpen() {
        if (!this.isOpen()) {
            throw new IllegalStateException("N\u00e3o foi poss\u00edvel executar a opera\u00e7\u00e3o pois o canal n\u00e3o est\u00e1 aberto.");
        }
    }
}

