/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_4.server;

import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import tecgraf.ftc_1_4.common.FileDataChannel;
import tecgraf.ftc_1_4.common.IDataChannel;
import tecgraf.ftc_1_4.common.exception.FailureException;
import tecgraf.ftc_1_4.common.exception.PermissionException;
import tecgraf.ftc_1_4.server.ChannelClosedReason;
import tecgraf.ftc_1_4.server.DataChannelProvider;

public class DefaultDataProvider
implements DataChannelProvider {
    @Override
    public IDataChannel createFileChannel(Object requester, byte[] fileId, boolean readOnly) throws PermissionException, FailureException {
        RandomAccessFile raf;
        String absolutePath;
        try {
            absolutePath = new String(fileId, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new FailureException(e);
        }
        String mode = "r";
        if (!readOnly) {
            mode = mode + "w";
        }
        try {
            raf = new RandomAccessFile(absolutePath, mode);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        return new FileDataChannel(raf.getChannel());
    }

    @Override
    public boolean isLocked(Object requester, byte[] fileId) {
        return false;
    }

    @Override
    public void fileChannelClosed(Object requester, byte[] fileId, ChannelClosedReason reason) {
        try {
            String absolutePath = new String(fileId, "UTF8");
            System.out.println("O arquivo " + absolutePath + " foi fechado.");
            System.out.println("raz\u00e3o: " + reason.toString());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }
}

