/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_4.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import tecgraf.ftc_1_4.common.IDataChannel;
import tecgraf.ftc_1_4.server.ChannelClosedReason;
import tecgraf.ftc_1_4.server.FileChannelRequestInfo;
import tecgraf.ftc_1_4.server.FileServer;
import tecgraf.ftc_1_4.server.states.State;
import tecgraf.ftc_1_4.server.states.SupportedProtocols;
import tecgraf.ftc_1_4.server.states.v1_4.VersionHandshakeState;

public final class Session {
    private SocketChannel channel = null;
    private ByteBuffer buffer = null;
    private FileServer fileServer = null;
    private SupportedProtocols protocol = SupportedProtocols.V1_4;
    private State currentState = null;
    private FileChannelRequestInfo fileChannelInfo = null;
    private IDataChannel fileChannel = null;
    private boolean readOnly = true;
    private long lastActivity = 0L;
    private boolean maxClients = false;
    private boolean valid = true;

    Session(SocketChannel channel, FileServer fileServer) {
        this.channel = channel;
        this.buffer = ByteBuffer.allocateDirect(fileServer.getConfig().getClientBufferSize());
        this.fileServer = fileServer;
        this.currentState = new VersionHandshakeState();
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public FileServer getFileServer() {
        return this.fileServer;
    }

    public State getCurrentState() {
        return this.currentState;
    }

    public void setCurrentState(State state) {
        this.currentState = state;
    }

    public FileChannelRequestInfo getFileChannelInfo() {
        return this.fileChannelInfo;
    }

    public void setFileChannelInfo(FileChannelRequestInfo fileChannelInfo) {
        this.fileChannelInfo = fileChannelInfo;
    }

    public IDataChannel getFileChannel() {
        return this.fileChannel;
    }

    public void setFileChannel(IDataChannel fileChannel) {
        this.fileChannel = fileChannel;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void close(ChannelClosedReason reason) {
        this.closeFileChannel(reason);
        try {
            this.channel.close();
        }
        catch (IOException e) {
            if (this.fileChannelInfo != null) {
                this.fileServer.exceptionRaised(e, this.fileChannelInfo.getFileId());
            }
            this.fileServer.exceptionRaised(e);
        }
        this.valid = false;
        this.currentState = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeFileChannel(ChannelClosedReason reason) {
        if (this.fileChannel == null) {
            return false;
        }
        try {
            this.fileChannel.close();
        }
        catch (IOException e) {
            if (this.fileChannelInfo != null) {
                this.fileServer.exceptionRaised(e, this.fileChannelInfo.getFileId());
            } else {
                this.fileServer.exceptionRaised(e);
            }
        }
        finally {
            this.fileChannel = null;
            this.fileServer.getDataProvider().fileChannelClosed(this.fileChannelInfo.getRequester(), this.fileChannelInfo.getFileId(), reason);
        }
        return true;
    }

    public long getLastActivity() {
        return this.lastActivity;
    }

    public void markLastActivity() {
        this.lastActivity = System.currentTimeMillis();
    }

    public SupportedProtocols getProtocol() {
        return this.protocol;
    }

    public void setProtocol(SupportedProtocols protocol) {
        this.protocol = protocol;
    }

    public void setMaxClientsReached(boolean value) {
        this.maxClients = value;
    }

    public boolean getMaxClientsReached() {
        return this.maxClients;
    }

    public boolean isWriting() {
        if (this.currentState == null) {
            return false;
        }
        return this.currentState.isWriting();
    }

    public boolean isValid() {
        return this.valid;
    }
}

