/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_4.server.states.v1_1;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc_1_4.common.IDataChannel;
import tecgraf.ftc_1_4.common.exception.FailureException;
import tecgraf.ftc_1_4.common.exception.PermissionException;
import tecgraf.ftc_1_4.common.logic.ErrorCode;
import tecgraf.ftc_1_4.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_4.server.FileChannelRequestInfo;
import tecgraf.ftc_1_4.server.FileServer;
import tecgraf.ftc_1_4.server.Session;
import tecgraf.ftc_1_4.server.states.State;
import tecgraf.ftc_1_4.server.states.v1_1.GetOperationState;

public abstract class OpenState
implements State {
    private InternalState currentState;
    private int fileIdSize;
    private byte[] fileId;
    private ErrorCode errorCode;
    private boolean readOnly;
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");
    private boolean writing = false;

    protected OpenState(boolean readOnly) {
        this.readOnly = readOnly;
        this.currentState = InternalState.INITIAL;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Estado de abertura de arquivo. Somente leitura? " + readOnly);
        }
    }

    @Override
    public boolean read(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case INITIAL: {
                buffer.limit(PrimitiveTypeSize.BYTE.getSize());
                try {
                    if (channel.read(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    session.getFileServer().exceptionRaised(e);
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.fileIdSize = buffer.get() & 0xFF;
                buffer.clear();
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Tamanho do identificador lido " + this.fileIdSize);
                }
                this.currentState = InternalState.IDENTIFIER_SIZE_RECEIVED;
            }
            case IDENTIFIER_SIZE_RECEIVED: {
                FileChannelRequestInfo fileChannelInfo;
                buffer.limit(this.fileIdSize);
                try {
                    if (channel.read(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.fileId = new byte[this.fileIdSize];
                buffer.get(this.fileId);
                buffer.clear();
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Identificador lido " + this.fileId);
                }
                if (this.fileId.equals((fileChannelInfo = session.getFileChannelInfo()).getFileId())) {
                    this.errorCode = ErrorCode.NO_PERMISSION;
                } else {
                    FileServer fileServer = session.getFileServer();
                    try {
                        IDataChannel fileChannel = fileServer.getDataProvider().createFileChannel(fileChannelInfo.getRequester(), fileChannelInfo.getFileId(), this.readOnly);
                        if (fileChannel == null) {
                            this.errorCode = ErrorCode.FILE_NOT_FOUND;
                        } else {
                            this.errorCode = ErrorCode.OK;
                            session.setFileChannel(fileChannel);
                        }
                    }
                    catch (FailureException e) {
                        this.errorCode = ErrorCode.FAILURE;
                    }
                    catch (PermissionException e) {
                        this.errorCode = ErrorCode.NO_PERMISSION;
                    }
                }
                buffer.limit(PrimitiveTypeSize.BYTE.getSize());
                buffer.put(this.errorCode.getCode());
                buffer.flip();
                this.writing = true;
                this.currentState = InternalState.IDENTIFIER_RECEIVED;
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean write(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case IDENTIFIER_RECEIVED: {
                try {
                    if (channel.write(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    logger.finer("Erro ao escrever no canal.");
                    session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                this.writing = false;
                buffer.clear();
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("C\u00f3digo " + (Object)((Object)this.errorCode) + " enviado.");
                }
                session.setCurrentState(new GetOperationState());
                return this.errorCode.equals((Object)ErrorCode.OK);
            }
        }
        return true;
    }

    @Override
    public boolean isWriting() {
        return this.writing;
    }

    protected static enum InternalState {
        INITIAL,
        IDENTIFIER_SIZE_RECEIVED,
        IDENTIFIER_RECEIVED;

    }
}

