/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_4.server.states.v1_1;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc_1_4.common.IDataChannel;
import tecgraf.ftc_1_4.common.exception.DataChannelException;
import tecgraf.ftc_1_4.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_4.server.FileServer;
import tecgraf.ftc_1_4.server.Session;
import tecgraf.ftc_1_4.server.states.State;
import tecgraf.ftc_1_4.server.states.v1_1.GetOperationState;

public final class ReadState
implements State {
    private InternalState currentState = InternalState.INITIAL;
    private long position;
    private long count;
    private boolean readUsesTransferTo = false;
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");
    public static final long MAX_BYTES = Integer.MAX_VALUE;
    private long bytesSent = 0L;
    private boolean writing = false;

    public ReadState() {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Estado de leitura.");
        }
    }

    @Override
    public boolean read(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        IDataChannel dataChannel = session.getFileChannel();
        switch (this.currentState) {
            case INITIAL: {
                buffer.limit(PrimitiveTypeSize.LONG.getSize());
                try {
                    if (channel.read(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    logger.finer("Erro ao ler do canal.");
                    session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.position = buffer.getLong();
                buffer.clear();
                this.currentState = InternalState.POSITION_READ;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Position " + this.position);
                }
            }
            case POSITION_READ: {
                buffer.limit(PrimitiveTypeSize.LONG.getSize());
                try {
                    if (channel.read(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    logger.finer("Erro ao ler do canal.");
                    session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.count = buffer.getLong();
                buffer.clear();
                this.readUsesTransferTo = (dataChannel.supportedOperations() & 0x80) != 0 && session.getFileChannelInfo().useTransferTo() && (this.count <= Integer.MAX_VALUE || !FileServer.PLATAFORM_HAS_TRANSFERTO_BUG);
                this.currentState = InternalState.BYTE_COUNT_READ;
                this.writing = true;
                buffer.limit(0);
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Quantidade pedida " + this.count);
                }
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean write(Session session) {
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case BYTE_COUNT_READ: {
                ByteBuffer buffer = session.getBuffer();
                IDataChannel fileChannel = session.getFileChannel();
                long bytesWritten = 0L;
                try {
                    long bytesToread = this.count - this.bytesSent;
                    bytesWritten = this.transferBytesToSocket(fileChannel, channel, buffer, bytesToread);
                    if (bytesWritten > 0L) {
                        session.markLastActivity();
                        this.bytesSent += bytesWritten;
                    }
                }
                catch (Exception e) {
                    buffer.clear();
                    session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                    return false;
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Enviados " + bytesWritten);
                }
                if (this.bytesSent == this.count) {
                    this.writing = false;
                    buffer.clear();
                    this.currentState = InternalState.BYTES_SENT;
                    session.setCurrentState(new GetOperationState());
                }
                return true;
            }
        }
        return true;
    }

    private long transferBytesToSocket(IDataChannel byteChannel, SocketChannel channel, ByteBuffer buffer, long bytesToread) throws IOException, UnsupportedOperationException, DataChannelException {
        long bytesWritten = -1L;
        if (this.readUsesTransferTo) {
            logger.finest("Using TransferTo");
            if (this.position == -1L) {
                this.position = byteChannel.getPosition();
            }
            logger.finest("position: " + this.position);
            logger.finest("size: " + byteChannel.getSize());
            bytesWritten = byteChannel.transferTo(this.position + this.bytesSent, bytesToread, channel);
        } else if (buffer.hasRemaining()) {
            bytesWritten = channel.write(buffer);
        } else {
            int bytesRead;
            if (this.position >= 0L) {
                byteChannel.setPosition(this.position + this.bytesSent);
            }
            buffer.clear();
            if ((long)buffer.remaining() > bytesToread) {
                buffer.limit((int)bytesToread);
            }
            if ((bytesRead = byteChannel.read(buffer)) == -1) {
                return -1L;
            }
            buffer.flip();
            bytesWritten = channel.write(buffer);
        }
        return bytesWritten;
    }

    @Override
    public boolean isWriting() {
        return this.writing;
    }

    private static enum InternalState {
        INITIAL,
        POSITION_READ,
        BYTE_COUNT_READ,
        BYTES_SENT;

    }
}

