/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_4.server.states.v1_1;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc_1_4.common.IDataChannel;
import tecgraf.ftc_1_4.common.logic.ErrorCode;
import tecgraf.ftc_1_4.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_4.server.Session;
import tecgraf.ftc_1_4.server.states.State;
import tecgraf.ftc_1_4.server.states.v1_1.GetOperationState;

public final class SetPositionState
implements State {
    private InternalState currentState = InternalState.INITIAL;
    private long position;
    private ErrorCode errorCode;
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");
    private boolean writing = false;

    public SetPositionState() {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Estado para definir a posi\u00e7\u00e3o de um arquivo.");
        }
    }

    @Override
    public boolean read(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case INITIAL: {
                buffer.limit(PrimitiveTypeSize.LONG.getSize());
                try {
                    if (channel.read(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    logger.finer("Erro ao ler do canal.");
                    session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.position = buffer.getLong();
                buffer.clear();
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Posi\u00e7\u00e3o recebida: " + this.position);
                }
                this.writing = true;
                IDataChannel byteChannel = session.getFileChannel();
                if ((byteChannel.supportedOperations() & 8) == 0) {
                    logger.finer("Opera\u00e7\u00e3o SET_POSITION n\u00e3o suportada pelo canal");
                    this.errorCode = ErrorCode.FAILURE;
                } else {
                    try {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("Novo posicao: " + this.position);
                        }
                        byteChannel.setPosition(this.position);
                        this.errorCode = ErrorCode.OK;
                    }
                    catch (Exception e) {
                        session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                        this.errorCode = ErrorCode.FAILURE;
                    }
                }
                buffer.limit(PrimitiveTypeSize.BYTE.getSize());
                buffer.put(this.errorCode.getCode());
                buffer.flip();
                this.currentState = InternalState.POSITION_READ;
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean write(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case POSITION_READ: {
                try {
                    if (channel.write(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                this.writing = false;
                buffer.clear();
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("C\u00f3digo " + (Object)((Object)this.errorCode) + " enviado.");
                }
                session.setCurrentState(new GetOperationState());
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean isWriting() {
        return this.writing;
    }

    private static enum InternalState {
        INITIAL,
        POSITION_READ;

    }
}

