/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_4.server.states.v1_2;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc_1_4.common.IDataChannel;
import tecgraf.ftc_1_4.common.logic.ErrorCode;
import tecgraf.ftc_1_4.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_4.server.Session;
import tecgraf.ftc_1_4.server.states.State;
import tecgraf.ftc_1_4.server.states.v1_2.GetOperationState;

public final class GetSizeState
implements State {
    private InternalState currentState;
    private long size = -1L;
    private ErrorCode errorCode = ErrorCode.FAILURE;
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");
    private boolean writing = true;

    public GetSizeState() {
        this.currentState = InternalState.INITIAL;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Estado de obten\u00e7\u00e3o do tamanho do arquivo.");
        }
    }

    @Override
    public boolean read(Session session) {
        return true;
    }

    @Override
    public boolean write(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case INITIAL: {
                IDataChannel byteChannel = session.getFileChannel();
                if ((byteChannel.supportedOperations() & 1) != 0) {
                    try {
                        this.size = byteChannel.getSize();
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("Tamanho atual: " + this.size);
                        }
                        this.errorCode = ErrorCode.OK;
                    }
                    catch (Exception e) {
                        logger.severe("Falha ao ler tamanho do arquivo!");
                        session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                    }
                } else {
                    logger.finer("Opera\u00e7\u00e3o GET_SIZE n\u00e3o suportada pelo canal");
                }
                if (this.errorCode.equals((Object)ErrorCode.OK)) {
                    buffer.limit(PrimitiveTypeSize.BYTE.getSize() + PrimitiveTypeSize.LONG.getSize());
                    buffer.put(this.errorCode.getCode());
                    buffer.putLong(this.size);
                } else {
                    buffer.limit(PrimitiveTypeSize.BYTE.getSize());
                    buffer.put(this.errorCode.getCode());
                }
                buffer.flip();
                this.currentState = InternalState.SIZE_READ;
            }
            case SIZE_READ: {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Enviando o tamanho do arquivo " + this.size);
                }
                try {
                    if (channel.write(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                this.writing = false;
                buffer.clear();
                session.setCurrentState(new GetOperationState());
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean isWriting() {
        return this.writing;
    }

    private static enum InternalState {
        INITIAL,
        SIZE_READ;

    }
}

