/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_4.server.states.v1_2;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc_1_4.common.IDataChannel;
import tecgraf.ftc_1_4.common.logic.ErrorCode;
import tecgraf.ftc_1_4.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_4.server.Session;
import tecgraf.ftc_1_4.server.states.State;
import tecgraf.ftc_1_4.server.states.v1_2.GetOperationState;

public final class SetSizeState
implements State {
    private InternalState currentState = InternalState.INITIAL;
    private ErrorCode errorCode;
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");
    private boolean writing = false;

    public SetSizeState() {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Estado que altera o tamanho de um arquivo.");
        }
    }

    @Override
    public boolean read(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case INITIAL: {
                buffer.limit(PrimitiveTypeSize.LONG.getSize());
                try {
                    if (channel.read(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    logger.finer("Erro ao ler do canal.");
                    session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                long size = buffer.getLong();
                buffer.clear();
                this.writing = true;
                IDataChannel byteChannel = session.getFileChannel();
                if ((byteChannel.supportedOperations() & 2) == 0) {
                    logger.finer("Opera\u00e7\u00e3o SET_SIZE n\u00e3o suportada pelo canal");
                    this.errorCode = ErrorCode.FAILURE;
                } else {
                    try {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("Novo tamanho: " + size);
                        }
                        byteChannel.setSize(size);
                        this.errorCode = ErrorCode.OK;
                    }
                    catch (Exception e) {
                        session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                        this.errorCode = ErrorCode.FAILURE;
                    }
                }
                buffer.limit(PrimitiveTypeSize.BYTE.getSize());
                buffer.put(this.errorCode.getCode());
                buffer.flip();
                this.currentState = InternalState.SIZE_READ;
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean write(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case SIZE_READ: {
                try {
                    if (channel.write(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    logger.finer("Erro ao escrever no canal.");
                    session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                this.writing = false;
                buffer.clear();
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("C\u00f3digo " + (Object)((Object)this.errorCode) + " enviado.");
                }
                session.setCurrentState(new GetOperationState());
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean isWriting() {
        return this.writing;
    }

    private static enum InternalState {
        INITIAL,
        SIZE_READ;

    }
}

