/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_4.server.states.v1_4;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc_1_4.common.IDataChannel;
import tecgraf.ftc_1_4.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_4.common.logic.ResultMessage;
import tecgraf.ftc_1_4.server.Session;
import tecgraf.ftc_1_4.server.states.State;
import tecgraf.ftc_1_4.server.states.StateUtil;
import tecgraf.ftc_1_4.server.states.v1_4.GetOperationState;

public final class GetPositionState
implements State {
    private InternalState currentState;
    private long position = -1L;
    private ResultMessage result = new ResultMessage();
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");
    private boolean writing = true;

    public GetPositionState() {
        this.currentState = InternalState.INITIAL;
        logger.finer("Estado de obten\u00e7\u00e3o de posi\u00e7\u00e3o.");
    }

    @Override
    public boolean read(Session session) {
        return true;
    }

    @Override
    public boolean write(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case INITIAL: {
                IDataChannel byteChannel = session.getFileChannel();
                if ((byteChannel.supportedOperations() & 4) != 0) {
                    try {
                        this.position = byteChannel.getPosition();
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("Posicao atual: " + this.position);
                        }
                        this.result.success = true;
                    }
                    catch (Exception e) {
                        logger.severe("Falha ao ler posi\u00e7\u00e3o do arquivo!");
                        session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                    }
                } else {
                    logger.finer("Opera\u00e7\u00e3o GET_POSITION n\u00e3o suportada pelo canal");
                }
                this.currentState = InternalState.POSITION_READ;
            }
            case POSITION_READ: {
                StateUtil.writeResultMessage(buffer, this.result);
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Resultado: " + this.result);
                }
                if (this.result.success.booleanValue()) {
                    buffer.limit(buffer.limit() + PrimitiveTypeSize.LONG.getSize());
                    buffer.putLong(this.position);
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Enviando a posi\u00e7\u00e3o do arquivo " + this.position);
                    }
                }
                buffer.flip();
                this.currentState = InternalState.RESULT_MESSAGE_WRITTEN;
            }
            case RESULT_MESSAGE_WRITTEN: {
                try {
                    if (channel.write(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                this.writing = false;
                buffer.clear();
                logger.finer("Resultado enviado.");
                session.setCurrentState(new GetOperationState());
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean isWriting() {
        return this.writing;
    }

    private static enum InternalState {
        INITIAL,
        POSITION_READ,
        RESULT_MESSAGE_WRITTEN;

    }
}

