/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_4.server.states.v1_4;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc_1_4.common.IDataChannel;
import tecgraf.ftc_1_4.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_4.common.logic.ResultMessage;
import tecgraf.ftc_1_4.server.Session;
import tecgraf.ftc_1_4.server.states.State;
import tecgraf.ftc_1_4.server.states.StateUtil;
import tecgraf.ftc_1_4.server.states.v1_4.GetOperationState;

public final class GetSizeState
implements State {
    private InternalState currentState;
    private long size = -1L;
    private ResultMessage result = new ResultMessage();
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");
    private boolean writing = true;

    public GetSizeState() {
        this.currentState = InternalState.INITIAL;
        logger.finer("Estado de obten\u00e7\u00e3o do tamanho do arquivo.");
    }

    @Override
    public boolean read(Session session) {
        return true;
    }

    @Override
    public boolean write(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case INITIAL: {
                IDataChannel byteChannel = session.getFileChannel();
                if ((byteChannel.supportedOperations() & 1) != 0) {
                    try {
                        this.size = byteChannel.getSize();
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("Tamanho atual: " + this.size);
                        }
                        this.result.success = true;
                    }
                    catch (Exception e) {
                        logger.severe("Falha ao ler tamanho do arquivo!");
                        session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                    }
                } else {
                    logger.finer("Opera\u00e7\u00e3o GET_SIZE n\u00e3o suportada pelo canal");
                }
                this.currentState = InternalState.SIZE_READ;
            }
            case SIZE_READ: {
                StateUtil.writeResultMessage(buffer, this.result);
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Resultado: " + this.result);
                }
                if (this.result.success.booleanValue()) {
                    buffer.limit(buffer.limit() + PrimitiveTypeSize.LONG.getSize());
                    buffer.putLong(this.size);
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Enviando o tamanho do arquivo " + this.size);
                    }
                }
                buffer.flip();
                this.currentState = InternalState.RESULT_MESSAGE_WRITTEN;
            }
            case RESULT_MESSAGE_WRITTEN: {
                try {
                    if (channel.write(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                this.writing = false;
                buffer.clear();
                logger.finer("Resultado enviado.");
                session.setCurrentState(new GetOperationState());
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean isWriting() {
        return this.writing;
    }

    private static enum InternalState {
        INITIAL,
        SIZE_READ,
        RESULT_MESSAGE_WRITTEN;

    }
}

