/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_4.server.states.v1_4;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc_1_4.common.IDataChannel;
import tecgraf.ftc_1_4.common.exception.FailureException;
import tecgraf.ftc_1_4.common.exception.PermissionException;
import tecgraf.ftc_1_4.common.logic.ErrorCode;
import tecgraf.ftc_1_4.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_4.common.logic.ResultMessage;
import tecgraf.ftc_1_4.server.FileChannelRequestInfo;
import tecgraf.ftc_1_4.server.FileServer;
import tecgraf.ftc_1_4.server.Session;
import tecgraf.ftc_1_4.server.states.State;
import tecgraf.ftc_1_4.server.states.StateUtil;
import tecgraf.ftc_1_4.server.states.v1_4.GetOperationState;

public abstract class OpenState
implements State {
    private InternalState currentState;
    private ResultMessage result = new ResultMessage();
    private boolean readOnly;
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");
    private boolean writing = false;

    protected OpenState(boolean readOnly) {
        this.readOnly = readOnly;
        this.currentState = InternalState.INITIAL;
        this.writing = true;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Estado de abertura de arquivo. Somente leitura? " + readOnly);
        }
    }

    @Override
    public boolean read(Session session) {
        switch (this.currentState) {
            case INITIAL: {
                FileChannelRequestInfo fileChannelInfo = session.getFileChannelInfo();
                FileServer fileServer = session.getFileServer();
                try {
                    IDataChannel fileChannel = fileServer.getDataProvider().createFileChannel(fileChannelInfo.getRequester(), fileChannelInfo.getFileId(), this.readOnly);
                    if (fileChannel == null) {
                        this.result.code = ErrorCode.FILE_NOT_FOUND;
                        this.result.message = "Nao foi possivel abrir o canal de dados";
                    } else {
                        this.result.success = true;
                        session.setFileChannel(fileChannel);
                    }
                }
                catch (FailureException e) {
                    this.result.code = ErrorCode.FAILURE;
                }
                catch (PermissionException e) {
                    this.result.code = ErrorCode.NO_PERMISSION;
                }
                this.currentState = InternalState.FILE_OPEN_RESULT;
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean write(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case FILE_OPEN_RESULT: {
                StateUtil.writeResultMessage(buffer, this.result);
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Resultado: " + this.result);
                }
                if (this.result.success.booleanValue()) {
                    buffer.limit(buffer.limit() + PrimitiveTypeSize.SHORT.getSize());
                    short ops = session.getFileChannel().supportedOperations();
                    buffer.putShort(ops);
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Operacoes suportadas: " + ops);
                    }
                }
                buffer.flip();
                this.currentState = InternalState.RESULT_MESSAGE_WRITTEN;
            }
            case RESULT_MESSAGE_WRITTEN: {
                try {
                    if (channel.write(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    logger.finer("Erro ao escrever no canal.");
                    session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                this.writing = false;
                buffer.clear();
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Resultado enviado.");
                }
                session.setCurrentState(new GetOperationState());
                return this.result.success != false;
            }
        }
        return true;
    }

    @Override
    public boolean isWriting() {
        return this.writing;
    }

    protected static enum InternalState {
        INITIAL,
        FILE_OPEN_RESULT,
        RESULT_MESSAGE_WRITTEN;

    }
}

