/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_4.server.states.v1_4;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc_1_4.common.IDataChannel;
import tecgraf.ftc_1_4.common.exception.DataChannelException;
import tecgraf.ftc_1_4.common.logic.ErrorCode;
import tecgraf.ftc_1_4.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_4.common.logic.ResultMessage;
import tecgraf.ftc_1_4.server.FileServer;
import tecgraf.ftc_1_4.server.Session;
import tecgraf.ftc_1_4.server.states.State;
import tecgraf.ftc_1_4.server.states.StateUtil;
import tecgraf.ftc_1_4.server.states.v1_4.GetOperationState;

public final class ReadState
implements State {
    private InternalState currentState = InternalState.INITIAL;
    private long position;
    private long count;
    private boolean readUsesTransferTo = false;
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");
    public static final long MAX_BYTES = Integer.MAX_VALUE;
    private long bytesSent = 0L;
    private long chunkBytesSent = 0L;
    private long currentChunkSize = 0L;
    private boolean changeState = false;
    private ResultMessage result = null;
    private boolean writing = false;

    public ReadState() {
        logger.finer("Estado de leitura.");
    }

    @Override
    public boolean read(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        IDataChannel dataChannel = session.getFileChannel();
        switch (this.currentState) {
            case INITIAL: {
                buffer.limit(PrimitiveTypeSize.LONG.getSize());
                try {
                    if (channel.read(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    logger.finer("Erro ao ler do canal.");
                    session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.position = buffer.getLong();
                buffer.clear();
                this.currentState = InternalState.POSITION_READ;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Position " + this.position);
                }
            }
            case POSITION_READ: {
                buffer.limit(PrimitiveTypeSize.LONG.getSize());
                try {
                    if (channel.read(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    logger.finer("Erro ao ler do canal.");
                    session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.count = buffer.getLong();
                buffer.clear();
                this.readUsesTransferTo = (dataChannel.supportedOperations() & 0x80) != 0 && session.getFileChannelInfo().useTransferTo() && (this.count <= Integer.MAX_VALUE || !FileServer.PLATAFORM_HAS_TRANSFERTO_BUG);
                this.currentState = InternalState.BYTE_COUNT_READ;
                this.writing = true;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Quantidade pedida " + this.count);
                }
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean write(Session session) {
        SocketChannel channel = session.getChannel();
        ByteBuffer buffer = session.getBuffer();
        IDataChannel byteChannel = session.getFileChannel();
        switch (this.currentState) {
            case BYTE_COUNT_READ: {
                this.result = new ResultMessage();
                buffer.clear();
                short operations = byteChannel.supportedOperations();
                if ((operations & 0x10) == 0 || this.position != -1L && (operations & 8) == 0) {
                    this.result.code = ErrorCode.UNSUPPORTED_OPERATION;
                    StateUtil.writeResultMessage(buffer, this.result);
                    this.changeState = true;
                } else {
                    try {
                        if (this.position >= 0L) {
                            byteChannel.setPosition(this.position + this.bytesSent);
                        }
                        this.changeState = this.createChunkHeader(session, buffer, byteChannel);
                    }
                    catch (Exception e) {
                        buffer.clear();
                        session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                        return false;
                    }
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Resultado: " + this.result);
                }
                buffer.flip();
                this.currentState = InternalState.CHUNK_HEADER_WRITTEN;
            }
            case CHUNK_HEADER_WRITTEN: {
                try {
                    if (channel.write(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    buffer.clear();
                    session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.clear();
                logger.finer("Resultado enviado.");
                if (this.changeState) {
                    session.setCurrentState(new GetOperationState());
                    return true;
                }
                buffer.limit(0);
                this.currentState = InternalState.CHUNK_HEADER_SENT;
            }
            case CHUNK_HEADER_SENT: {
                long bytesToread = this.currentChunkSize - this.chunkBytesSent;
                long bytesWritten = 0L;
                try {
                    bytesWritten = this.transferBytesToSocket(byteChannel, channel, buffer, bytesToread);
                    if (bytesWritten > 0L) {
                        session.markLastActivity();
                        this.bytesSent += bytesWritten;
                    }
                }
                catch (Exception e) {
                    buffer.clear();
                    session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                    return false;
                }
                if (bytesWritten == -1L) {
                    return true;
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Enviados " + bytesWritten);
                }
                this.chunkBytesSent += bytesWritten;
                if (this.chunkBytesSent == this.currentChunkSize) {
                    logger.finest("Final chunck sent");
                    buffer.clear();
                    this.chunkBytesSent = 0L;
                    this.currentState = InternalState.BYTE_COUNT_READ;
                }
                if (this.bytesSent == this.count) {
                    logger.finest("Final bytes sent");
                    this.writing = false;
                    buffer.clear();
                    this.currentState = InternalState.BYTES_SENT;
                    session.setCurrentState(new GetOperationState());
                }
                return true;
            }
        }
        return true;
    }

    private boolean createChunkHeader(Session session, ByteBuffer buffer, IDataChannel dataChannel) throws IOException, DataChannelException {
        boolean returnValue = false;
        long bytesLeftOnFile = dataChannel.remaining();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Bytes left on file: " + bytesLeftOnFile);
        }
        if (bytesLeftOnFile < 0L) {
            logger.finer("Final do arquivo atingido enviando EOF");
            this.result.code = ErrorCode.END_OF_FILE;
            StateUtil.writeResultMessage(buffer, this.result);
            returnValue = true;
        } else {
            long missingBytes = this.count - this.bytesSent;
            this.currentChunkSize = Math.min(Math.min(missingBytes, (long)session.getFileServer().getConfig().getChunkSize()), bytesLeftOnFile);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Enviando chunk de tamanho " + this.currentChunkSize);
            }
            this.result.success = true;
            StateUtil.writeResultMessage(buffer, this.result);
            buffer.limit(buffer.limit() + PrimitiveTypeSize.INTEGER.getSize());
            buffer.putInt((int)(this.currentChunkSize & 0xFFFFFFFFFFFFFFFFL));
        }
        return returnValue;
    }

    private long transferBytesToSocket(IDataChannel byteChannel, SocketChannel channel, ByteBuffer buffer, long bytesToread) throws IOException, UnsupportedOperationException, DataChannelException {
        long bytesWritten = -1L;
        if (this.readUsesTransferTo) {
            logger.finest("Using TransferTo");
            if (this.position == -1L) {
                this.position = byteChannel.getPosition();
            }
            bytesWritten = byteChannel.transferTo(this.position + this.bytesSent, bytesToread, channel);
        } else if (buffer.hasRemaining()) {
            bytesWritten = channel.write(buffer);
        } else {
            int bytesRead;
            if (this.position >= 0L) {
                byteChannel.setPosition(this.position + this.bytesSent);
            }
            buffer.clear();
            if ((long)buffer.remaining() > bytesToread) {
                buffer.limit((int)bytesToread);
            }
            if ((bytesRead = byteChannel.read(buffer)) == -1) {
                return -1L;
            }
            buffer.flip();
            bytesWritten = channel.write(buffer);
        }
        return bytesWritten;
    }

    @Override
    public boolean isWriting() {
        return this.writing;
    }

    private static enum InternalState {
        INITIAL,
        POSITION_READ,
        BYTE_COUNT_READ,
        CHUNK_HEADER_WRITTEN,
        CHUNK_HEADER_SENT,
        BYTES_SENT;

    }
}

