/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_4.server.states.v1_4;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc_1_4.common.IDataChannel;
import tecgraf.ftc_1_4.common.logic.ErrorCode;
import tecgraf.ftc_1_4.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_4.common.logic.ResultMessage;
import tecgraf.ftc_1_4.server.Session;
import tecgraf.ftc_1_4.server.states.State;
import tecgraf.ftc_1_4.server.states.StateUtil;
import tecgraf.ftc_1_4.server.states.v1_4.GetOperationState;

public final class SetPositionState
implements State {
    private InternalState currentState;
    private long position;
    private ResultMessage result = new ResultMessage();
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");
    private boolean writing = false;

    public SetPositionState() {
        this.currentState = InternalState.INITIAL;
        logger.finer("Estado para definir a posi\u00e7\u00e3o de um arquivo.");
    }

    @Override
    public boolean read(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case INITIAL: {
                buffer.limit(PrimitiveTypeSize.LONG.getSize());
                try {
                    if (channel.read(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    logger.finer("Erro ao ler do canal.");
                    session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.position = buffer.getLong();
                buffer.clear();
                this.writing = true;
                IDataChannel byteChannel = session.getFileChannel();
                if ((byteChannel.supportedOperations() & 8) == 0) {
                    logger.finer("Opera\u00e7\u00e3o SET_POSITION n\u00e3o suportada pelo canal");
                    this.result.code = ErrorCode.FAILURE;
                } else {
                    try {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("Movendo para a posicao: " + this.position);
                        }
                        byteChannel.setPosition(this.position);
                        this.result.success = true;
                    }
                    catch (Exception e) {
                        session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                        this.result.code = ErrorCode.FAILURE;
                    }
                }
                this.currentState = InternalState.POSITION_READ;
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean write(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case POSITION_READ: {
                StateUtil.writeResultMessage(buffer, this.result);
                buffer.flip();
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Resultado: " + this.result);
                }
                this.currentState = InternalState.RESULT_MESSAGE_WRITTEN;
            }
            case RESULT_MESSAGE_WRITTEN: {
                try {
                    if (channel.write(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    logger.finer("Erro ao escrever no canal.");
                    session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                this.writing = false;
                buffer.clear();
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Resultado enviado.");
                }
                session.setCurrentState(new GetOperationState());
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean isWriting() {
        return this.writing;
    }

    private static enum InternalState {
        INITIAL,
        POSITION_READ,
        RESULT_MESSAGE_WRITTEN;

    }
}

