/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_4.server.states.v1_4;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc_1_4.common.IDataChannel;
import tecgraf.ftc_1_4.common.logic.ErrorCode;
import tecgraf.ftc_1_4.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_4.common.logic.ResultMessage;
import tecgraf.ftc_1_4.server.Session;
import tecgraf.ftc_1_4.server.states.State;
import tecgraf.ftc_1_4.server.states.StateUtil;
import tecgraf.ftc_1_4.server.states.v1_4.GetOperationState;

public final class SetSizeState
implements State {
    private InternalState currentState;
    private ResultMessage result = new ResultMessage();
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");
    private boolean writing = false;

    public SetSizeState() {
        this.currentState = InternalState.INITIAL;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Estado que altera o tamanho de um arquivo.");
        }
    }

    @Override
    public boolean read(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case INITIAL: {
                buffer.limit(PrimitiveTypeSize.LONG.getSize());
                try {
                    if (channel.read(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    logger.finer("Erro ao ler do canal.");
                    session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                long size = buffer.getLong();
                buffer.clear();
                this.writing = true;
                IDataChannel byteChannel = session.getFileChannel();
                if ((byteChannel.supportedOperations() & 2) == 0) {
                    logger.finer("Opera\u00e7\u00e3o SET_SIZE n\u00e3o suportada pelo canal");
                    this.result.code = ErrorCode.UNSUPPORTED_OPERATION;
                } else {
                    try {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("Definindo o tamanho: " + size);
                        }
                        byteChannel.setSize(size);
                        this.result.success = true;
                    }
                    catch (Exception e) {
                        session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                        this.result.code = ErrorCode.FAILURE;
                        this.result.message = e.getMessage();
                    }
                }
                this.currentState = InternalState.SIZE_READ;
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean write(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case SIZE_READ: {
                StateUtil.writeResultMessage(buffer, this.result);
                buffer.flip();
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Resultado: " + this.result);
                }
                this.currentState = InternalState.RESULT_MESSAGE_WRITTEN;
            }
            case RESULT_MESSAGE_WRITTEN: {
                try {
                    if (channel.write(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    logger.finer("Erro ao escrever no canal.");
                    session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                this.writing = false;
                buffer.clear();
                logger.finer("Resultado enviado.");
                session.setCurrentState(new GetOperationState());
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean isWriting() {
        return this.writing;
    }

    private static enum InternalState {
        INITIAL,
        SIZE_READ,
        RESULT_MESSAGE_WRITTEN;

    }
}

