/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_4.server.states.v1_4;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc_1_4.common.exception.InvalidArraySize;
import tecgraf.ftc_1_4.common.logic.ErrorCode;
import tecgraf.ftc_1_4.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_4.common.logic.ResultMessage;
import tecgraf.ftc_1_4.server.AccessKey;
import tecgraf.ftc_1_4.server.FileChannelRequestInfo;
import tecgraf.ftc_1_4.server.FileServer;
import tecgraf.ftc_1_4.server.Session;
import tecgraf.ftc_1_4.server.states.State;
import tecgraf.ftc_1_4.server.states.StateUtil;
import tecgraf.ftc_1_4.server.states.v1_4.GetOperationState;

public final class ValidateKeyState
implements State {
    private InternalState currentState;
    private int keySize;
    private byte[] key;
    private ResultMessage result = new ResultMessage();
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");
    private boolean writing = false;

    public ValidateKeyState() {
        this.currentState = InternalState.INITIAL;
        logger.finer("Estado de valida\u00e7\u00e3o de chave.");
    }

    @Override
    public boolean read(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case INITIAL: {
                buffer.limit(PrimitiveTypeSize.BYTE.getSize());
                try {
                    if (channel.read(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    logger.finer("Erro ao ler dados do canal");
                    session.getFileServer().exceptionRaised(e);
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.keySize = buffer.get() & 0xFF;
                buffer.clear();
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Tamanho da chave lido " + this.keySize);
                }
                this.currentState = InternalState.KEY_SIZE_RECEIVED;
            }
            case KEY_SIZE_RECEIVED: {
                buffer.limit(this.keySize);
                try {
                    if (channel.read(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    logger.finer("Erro ao ler dados do canal");
                    session.getFileServer().exceptionRaised(e);
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.key = new byte[this.keySize];
                buffer.get(this.key);
                buffer.clear();
                this.writing = true;
                FileServer fileServer = session.getFileServer();
                AccessKey accessKey = null;
                try {
                    accessKey = new AccessKey(this.key);
                }
                catch (InvalidArraySize e) {
                    this.result.code = ErrorCode.INVALID_KEY;
                }
                FileChannelRequestInfo fileChannelInfo = fileServer.getFileChannelInfo(accessKey);
                if (fileChannelInfo == null) {
                    this.result.code = ErrorCode.INVALID_KEY;
                } else {
                    this.result.success = true;
                    session.setFileChannelInfo(fileChannelInfo);
                }
                this.currentState = InternalState.KEY_RECEIVED;
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean write(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case KEY_RECEIVED: {
                StateUtil.writeResultMessage(buffer, this.result);
                buffer.flip();
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Resultado: " + this.result);
                }
                this.currentState = InternalState.RESULT_MESSAGE_WRITTEN;
            }
            case RESULT_MESSAGE_WRITTEN: {
                try {
                    if (channel.write(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    logger.finer("Erro ao escrever no canal");
                    session.getFileServer().exceptionRaised(e);
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                this.writing = false;
                buffer.clear();
                logger.finer("Resultado enviado.");
                this.currentState = InternalState.RESULT_MESSAGE_SENT;
                GetOperationState newState = this.result.success != false ? new GetOperationState() : null;
                session.setCurrentState(newState);
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean isWriting() {
        return this.writing;
    }

    private static enum InternalState {
        INITIAL,
        KEY_SIZE_RECEIVED,
        KEY_RECEIVED,
        RESULT_MESSAGE_WRITTEN,
        RESULT_MESSAGE_SENT;

    }
}

