/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_4.server.states.v1_4;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc_1_4.common.logic.ErrorCode;
import tecgraf.ftc_1_4.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_4.common.logic.ResultMessage;
import tecgraf.ftc_1_4.server.Session;
import tecgraf.ftc_1_4.server.states.State;
import tecgraf.ftc_1_4.server.states.StateUtil;
import tecgraf.ftc_1_4.server.states.SupportedProtocols;
import tecgraf.ftc_1_4.server.states.v1_4.CloseState;
import tecgraf.ftc_1_4.server.states.v1_4.ValidateKeyState;

public class VersionHandshakeState
implements State {
    private InternalState currentState;
    private ResultMessage result = new ResultMessage();
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");
    private boolean writing = false;

    public VersionHandshakeState() {
        this.currentState = InternalState.INITIAL;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Estado que lida com o handshake inicial.");
        }
    }

    @Override
    public boolean read(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case INITIAL: {
                buffer.limit(PrimitiveTypeSize.BYTE.getSize());
                try {
                    if (channel.read(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.warning("Erro ao ler do canal com endere\u00e7o " + channel.socket().getRemoteSocketAddress());
                    }
                    session.getFileServer().exceptionRaised(e);
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                if (buffer.get(0) != 0) {
                    session.setProtocol(SupportedProtocols.V1_1);
                    if (session.getMaxClientsReached()) {
                        session.setCurrentState(new tecgraf.ftc_1_4.server.states.v1_1.CloseState(ErrorCode.MAX_CLIENTS_REACHED));
                    } else {
                        session.setCurrentState(new tecgraf.ftc_1_4.server.states.v1_1.ValidateKeyState());
                    }
                    return true;
                }
                this.currentState = InternalState.FTC_1_1_PROTOCOL_CHECKED;
            }
            case FTC_1_1_PROTOCOL_CHECKED: {
                buffer.limit(PrimitiveTypeSize.INTEGER.getSize());
                try {
                    if (channel.read(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.warning("Erro ao ler do canal com endere\u00e7o " + channel.socket().getRemoteSocketAddress());
                    }
                    session.getFileServer().exceptionRaised(e);
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                int protocolId = buffer.getInt();
                buffer.clear();
                if (protocolId != 4609091) {
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.warning("Cliente enviou uma mensagem inv\u00e1lida.");
                    }
                    this.currentState = InternalState.VERSION_RECEIVED;
                    this.result.code = ErrorCode.INVALID_PROTOCOL_MESSAGE;
                    return true;
                }
                this.currentState = InternalState.PROTOCOL_ID_RECEIVED;
            }
            case PROTOCOL_ID_RECEIVED: {
                buffer.limit(PrimitiveTypeSize.INTEGER.getSize());
                try {
                    if (channel.read(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.warning("Erro ao ler do canal com endere\u00e7o " + channel.socket().getRemoteSocketAddress());
                    }
                    session.getFileServer().exceptionRaised(e);
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                buffer.get();
                byte major_version = buffer.get();
                byte minor_version = buffer.get();
                byte patch_version = buffer.get();
                buffer.clear();
                this.writing = true;
                this.currentState = InternalState.VERSION_RECEIVED;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Cliente conectado utilizando vers\u00e3o: " + major_version + "." + minor_version + "." + patch_version);
                }
                if (major_version == 1 && (minor_version == 4 || minor_version == 2)) {
                    this.result.success = true;
                    if (minor_version == 2) {
                        session.setProtocol(SupportedProtocols.V1_2);
                    }
                } else {
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.warning("Vers\u00e3o n\u00e3o suportada por este servidor");
                    }
                    this.result.code = ErrorCode.INVALID_VERSION;
                }
                if (session.getMaxClientsReached()) {
                    State state;
                    switch (session.getProtocol()) {
                        case V1_2: {
                            state = new tecgraf.ftc_1_4.server.states.v1_2.CloseState(ErrorCode.MAX_CLIENTS_REACHED);
                            break;
                        }
                        case V1_4: {
                            state = new CloseState(ErrorCode.MAX_CLIENTS_REACHED);
                            break;
                        }
                        default: {
                            state = new CloseState(ErrorCode.FAILURE);
                        }
                    }
                    session.setCurrentState(state);
                    return true;
                }
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean write(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case VERSION_RECEIVED: {
                StateUtil.writeResultMessage(buffer, this.result);
                buffer.flip();
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Resultado: " + this.result);
                }
                this.currentState = InternalState.RESULT_MESSAGE_WRITTEN;
            }
            case RESULT_MESSAGE_WRITTEN: {
                State state;
                try {
                    if (channel.write(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.warning("Erro ao escrever no canal com endere\u00e7o " + channel.socket().getRemoteSocketAddress());
                    }
                    session.getFileServer().exceptionRaised(e);
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                this.writing = false;
                buffer.clear();
                logger.finest("Resultado enviado.");
                this.currentState = InternalState.RESULT_MESSAGE_SENT;
                if (!this.result.success.booleanValue()) {
                    return false;
                }
                switch (session.getProtocol()) {
                    case V1_2: {
                        state = new tecgraf.ftc_1_4.server.states.v1_2.ValidateKeyState();
                        break;
                    }
                    case V1_4: {
                        state = new ValidateKeyState();
                        break;
                    }
                    default: {
                        state = new CloseState();
                    }
                }
                session.setCurrentState(state);
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean isWriting() {
        return this.writing;
    }

    private static enum InternalState {
        INITIAL,
        FTC_1_1_PROTOCOL_CHECKED,
        PROTOCOL_ID_RECEIVED,
        VERSION_RECEIVED,
        RESULT_MESSAGE_WRITTEN,
        RESULT_MESSAGE_SENT;

    }
}

