/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_4.common;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import tecgraf.ftc_1_4.common.IDataChannel;
import tecgraf.ftc_1_4.common.exception.DataChannelException;

public class DataChannelInputStream
extends InputStream {
    private IDataChannel channel;

    public DataChannelInputStream(IDataChannel channel) {
        if (channel == null) {
            throw new NullPointerException();
        }
        this.channel = channel;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public int read() throws IOException {
        byte[] array = new byte[]{0};
        int ret = this.read(array);
        if (ret == 1) {
            return array[0];
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            ByteBuffer buffer = ByteBuffer.wrap(b, off, len);
            return this.channel.read(buffer);
        }
        catch (DataChannelException e) {
            throw new IOException(e);
        }
    }
}

