/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_4.server;

import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.logging.Logger;
import tecgraf.ftc_1_4.common.FileDataChannel;
import tecgraf.ftc_1_4.common.IDataChannel;
import tecgraf.ftc_1_4.common.exception.FailureException;
import tecgraf.ftc_1_4.common.exception.PermissionException;
import tecgraf.ftc_1_4.server.ChannelClosedReason;
import tecgraf.ftc_1_4.server.DataChannelProvider;

public class DefaultDataProvider
implements DataChannelProvider {
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");

    @Override
    public IDataChannel createFileChannel(Object requester, byte[] fileId, boolean readOnly) throws PermissionException, FailureException {
        RandomAccessFile raf;
        String absolutePath;
        try {
            absolutePath = new String(fileId, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new FailureException(e);
        }
        String mode = "r";
        if (!readOnly) {
            mode = mode + "w";
        }
        try {
            raf = new RandomAccessFile(absolutePath, mode);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        return new FileDataChannel(raf.getChannel());
    }

    @Override
    public boolean isLocked(Object requester, byte[] fileId) {
        return false;
    }

    @Override
    public void fileChannelClosed(Object requester, byte[] fileId, ChannelClosedReason reason) {
        String absolutePath;
        try {
            absolutePath = new String(fileId, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            absolutePath = new String(fileId);
            e.printStackTrace();
        }
        System.err.println(String.format("File channel related to requester %s and id %s was closed with reason %s", new Object[]{requester != null ? requester : "<none>", absolutePath, reason}));
    }
}

