/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_4.server.states.v1_1;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc_1_4.common.IDataChannel;
import tecgraf.ftc_1_4.common.logic.ErrorCode;
import tecgraf.ftc_1_4.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_4.server.ErrorMessages;
import tecgraf.ftc_1_4.server.Session;
import tecgraf.ftc_1_4.server.states.State;
import tecgraf.ftc_1_4.server.states.v1_1.GetOperationState;

public final class GetPositionState
implements State {
    private InternalState currentState = InternalState.INITIAL;
    private long position = -1L;
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");
    private boolean writing = true;

    @Override
    public boolean read(Session session) {
        return true;
    }

    @Override
    public boolean write(Session session) throws IOException {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        SocketAddress clientAddress = channel.socket().getRemoteSocketAddress();
        switch (this.currentState) {
            case INITIAL: {
                IDataChannel byteChannel = session.getFileChannel();
                if ((byteChannel.supportedOperations() & 4) != 0) {
                    try {
                        this.position = byteChannel.getPosition();
                    }
                    catch (Exception e) {
                        byte[] fileId = session.getFileChannelInfo().getFileId();
                        if (logger.isLoggable(Level.SEVERE)) {
                            logger.log(Level.SEVERE, String.format("Failed to retrieve data channel position (connection %s) for fileId %s", clientAddress, ErrorMessages.hexString(fileId)), e);
                        }
                        session.getFileServer().exceptionRaised(e, fileId);
                    }
                } else if (logger.isLoggable(Level.WARNING)) {
                    logger.warning(String.format("GET_POSITION operation requested by %s is not supported on data channel for fileId %s", clientAddress, ErrorMessages.hexString(session.getFileChannelInfo().getFileId())));
                }
                buffer.limit(PrimitiveTypeSize.LONG.getSize());
                buffer.putLong(this.position);
                buffer.flip();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(String.format("Get position operation result (%s) written into buffer to connection %s", new Object[]{this.position != -1L ? ErrorCode.OK : ErrorCode.FAILURE, clientAddress}));
                }
                this.currentState = InternalState.POSITION_READ;
            }
            case POSITION_READ: {
                if (channel.write(buffer) > 0) {
                    session.markLastActivity();
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                this.writing = false;
                buffer.clear();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(String.format("Get position operation result (%s) sent successfully to %s", (Object)((Object)(this.position != -1L ? ErrorCode.OK : ErrorCode.FAILURE)) + " value: " + this.position, clientAddress));
                }
                session.setCurrentState(new GetOperationState());
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean isWriting() {
        return this.writing;
    }

    private static enum InternalState {
        INITIAL,
        POSITION_READ;

    }
}

