/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_4.server.states.v1_1;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc_1_4.common.IDataChannel;
import tecgraf.ftc_1_4.common.exception.FailureException;
import tecgraf.ftc_1_4.common.exception.PermissionException;
import tecgraf.ftc_1_4.common.logic.ErrorCode;
import tecgraf.ftc_1_4.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_4.server.ErrorMessages;
import tecgraf.ftc_1_4.server.FileChannelRequestInfo;
import tecgraf.ftc_1_4.server.FileServer;
import tecgraf.ftc_1_4.server.Session;
import tecgraf.ftc_1_4.server.states.State;
import tecgraf.ftc_1_4.server.states.v1_1.GetOperationState;

public abstract class OpenState
implements State {
    private InternalState currentState = InternalState.INITIAL;
    private int fileIdSize;
    private byte[] fileId;
    private ErrorCode errorCode;
    private boolean readOnly;
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");
    private boolean writing = false;

    protected OpenState(boolean readOnly) {
        this.readOnly = readOnly;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(OpenState.class.getCanonicalName() + " readOnly=" + readOnly);
        }
    }

    @Override
    public boolean read(Session session) throws IOException {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        SocketAddress clientAddress = channel.socket().getRemoteSocketAddress();
        switch (this.currentState) {
            case INITIAL: {
                buffer.limit(PrimitiveTypeSize.BYTE.getSize());
                if (channel.read(buffer) < 0) {
                    return false;
                }
                session.markLastActivity();
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.fileIdSize = buffer.get() & 0xFF;
                buffer.clear();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(String.format("File id length %d received successfully from %s", this.fileIdSize, clientAddress));
                }
                this.currentState = InternalState.IDENTIFIER_SIZE_RECEIVED;
            }
            case IDENTIFIER_SIZE_RECEIVED: {
                buffer.limit(this.fileIdSize);
                if (channel.read(buffer) < 0) {
                    return false;
                }
                session.markLastActivity();
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.fileId = new byte[this.fileIdSize];
                buffer.get(this.fileId);
                buffer.clear();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(String.format("File id array %s received successfully from %s", ErrorMessages.hexString(this.fileId), clientAddress));
                }
                FileChannelRequestInfo fileChannelInfo = session.getFileChannelInfo();
                FileServer fileServer = session.getFileServer();
                try {
                    IDataChannel fileChannel = fileServer.getDataProvider().createFileChannel(fileChannelInfo.getRequester(), fileChannelInfo.getFileId(), this.readOnly);
                    if (fileChannel == null) {
                        this.errorCode = ErrorCode.FILE_NOT_FOUND;
                    } else {
                        this.errorCode = ErrorCode.OK;
                        session.setFileChannel(fileChannel);
                    }
                }
                catch (FailureException e) {
                    this.errorCode = ErrorCode.FAILURE;
                }
                catch (PermissionException e) {
                    this.errorCode = ErrorCode.NO_PERMISSION;
                }
                buffer.limit(PrimitiveTypeSize.BYTE.getSize());
                buffer.put(this.errorCode.getCode());
                buffer.flip();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(String.format("Open operation result (%s) written into buffer to connection %s", new Object[]{this.errorCode, clientAddress}));
                }
                this.writing = true;
                this.currentState = InternalState.IDENTIFIER_RECEIVED;
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean write(Session session) throws IOException {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case IDENTIFIER_RECEIVED: {
                if (channel.write(buffer) > 0) {
                    session.markLastActivity();
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                this.writing = false;
                buffer.clear();
                if (logger.isLoggable(Level.FINEST)) {
                    SocketAddress clientAddress = channel.socket().getRemoteSocketAddress();
                    logger.finest(String.format("Open operation result (%s) sent successfully to %s", new Object[]{this.errorCode, clientAddress}));
                }
                session.setCurrentState(new GetOperationState());
                return this.errorCode.equals((Object)ErrorCode.OK);
            }
        }
        return true;
    }

    @Override
    public boolean isWriting() {
        return this.writing;
    }

    protected static enum InternalState {
        INITIAL,
        IDENTIFIER_SIZE_RECEIVED,
        IDENTIFIER_RECEIVED;

    }
}

