/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_4.server.states.v1_4;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc_1_4.common.IDataChannel;
import tecgraf.ftc_1_4.common.exception.FailureException;
import tecgraf.ftc_1_4.common.exception.PermissionException;
import tecgraf.ftc_1_4.common.logic.ErrorCode;
import tecgraf.ftc_1_4.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_4.common.logic.ResultMessage;
import tecgraf.ftc_1_4.server.FileChannelRequestInfo;
import tecgraf.ftc_1_4.server.FileServer;
import tecgraf.ftc_1_4.server.Session;
import tecgraf.ftc_1_4.server.states.State;
import tecgraf.ftc_1_4.server.states.StateUtil;
import tecgraf.ftc_1_4.server.states.v1_4.GetOperationState;

public abstract class OpenState
implements State {
    private InternalState currentState = InternalState.INITIAL;
    private ResultMessage result = new ResultMessage();
    private boolean readOnly;
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");
    private boolean writing = true;

    protected OpenState(boolean readOnly) {
        this.readOnly = readOnly;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(OpenState.class.getCanonicalName() + " readOnly=" + readOnly);
        }
    }

    @Override
    public boolean read(Session session) {
        return true;
    }

    @Override
    public boolean write(Session session) throws IOException {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        SocketAddress clientAddress = channel.socket().getRemoteSocketAddress();
        switch (this.currentState) {
            case INITIAL: {
                FileChannelRequestInfo fileChannelInfo = session.getFileChannelInfo();
                FileServer fileServer = session.getFileServer();
                try {
                    IDataChannel fileChannel = fileServer.getDataProvider().createFileChannel(fileChannelInfo.getRequester(), fileChannelInfo.getFileId(), this.readOnly);
                    if (fileChannel == null) {
                        this.result.code = ErrorCode.FILE_NOT_FOUND;
                        this.result.message = "No data channel was provided by server for requested fileId";
                    } else {
                        this.result.success = true;
                        session.setFileChannel(fileChannel);
                    }
                }
                catch (FailureException e) {
                    this.result.code = ErrorCode.FAILURE;
                    this.result.message = e.getMessage();
                }
                catch (PermissionException e) {
                    this.result.code = ErrorCode.NO_PERMISSION;
                    this.result.message = e.getMessage();
                }
                this.currentState = InternalState.FILE_OPEN_RESULT;
            }
            case FILE_OPEN_RESULT: {
                StateUtil.writeResultMessage(buffer, this.result);
                if (this.result.success.booleanValue()) {
                    buffer.limit(buffer.limit() + PrimitiveTypeSize.SHORT.getSize());
                    short ops = session.getFileChannel().supportedOperations();
                    buffer.putShort(ops);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest(String.format("Channel opened by %s has support to the following operations %s", clientAddress, new Formatter().format("0x%X", ops)));
                    }
                }
                buffer.flip();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(String.format("Open operation result (%s) written into buffer to connection %s", this.result, clientAddress));
                }
                this.currentState = InternalState.RESULT_MESSAGE_WRITTEN;
            }
            case RESULT_MESSAGE_WRITTEN: {
                if (channel.write(buffer) > 0) {
                    session.markLastActivity();
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                this.writing = false;
                buffer.clear();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(String.format("Open operation result (%s) sent successfully to %s", this.result, clientAddress));
                }
                session.setCurrentState(new GetOperationState());
                return this.result.success != false;
            }
        }
        return true;
    }

    @Override
    public boolean isWriting() {
        return this.writing;
    }

    protected static enum InternalState {
        INITIAL,
        FILE_OPEN_RESULT,
        RESULT_MESSAGE_WRITTEN;

    }
}

