/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_4.server.states.v1_4;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc_1_4.common.logic.ErrorCode;
import tecgraf.ftc_1_4.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_4.common.logic.ResultMessage;
import tecgraf.ftc_1_4.server.Session;
import tecgraf.ftc_1_4.server.states.State;
import tecgraf.ftc_1_4.server.states.StateUtil;
import tecgraf.ftc_1_4.server.states.SupportedProtocols;
import tecgraf.ftc_1_4.server.states.v1_4.CloseState;
import tecgraf.ftc_1_4.server.states.v1_4.ValidateKeyState;

public class VersionHandshakeState
implements State {
    private InternalState currentState = InternalState.INITIAL;
    private ResultMessage result = new ResultMessage();
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");
    private boolean writing = false;

    @Override
    public boolean read(Session session) throws IOException {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        SocketAddress clientAddress = channel.socket().getRemoteSocketAddress();
        switch (this.currentState) {
            case INITIAL: {
                buffer.limit(PrimitiveTypeSize.BYTE.getSize());
                if (channel.read(buffer) < 0) {
                    return false;
                }
                session.markLastActivity();
                if (buffer.hasRemaining()) {
                    return true;
                }
                if (buffer.get(0) != 0) {
                    session.setProtocol(SupportedProtocols.V1_1);
                    if (session.getMaxClientsReached()) {
                        buffer.clear();
                        session.setCurrentState(new tecgraf.ftc_1_4.server.states.v1_1.CloseState(ErrorCode.MAX_CLIENTS_REACHED));
                    } else {
                        session.setCurrentState(new tecgraf.ftc_1_4.server.states.v1_1.ValidateKeyState());
                    }
                    return true;
                }
                this.currentState = InternalState.FTC_1_1_PROTOCOL_CHECKED;
            }
            case FTC_1_1_PROTOCOL_CHECKED: {
                buffer.limit(PrimitiveTypeSize.INTEGER.getSize());
                if (channel.read(buffer) < 0) {
                    return false;
                }
                session.markLastActivity();
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                int protocolId = buffer.getInt();
                buffer.clear();
                if (protocolId != 4609091) {
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.warning(String.format("Invalid protocol message received from connection %s", clientAddress));
                    }
                    this.currentState = InternalState.VERSION_RECEIVED;
                    this.result.code = ErrorCode.INVALID_PROTOCOL_MESSAGE;
                    return true;
                }
                this.currentState = InternalState.PROTOCOL_ID_RECEIVED;
            }
            case PROTOCOL_ID_RECEIVED: {
                buffer.limit(PrimitiveTypeSize.INTEGER.getSize());
                if (channel.read(buffer) < 0) {
                    return false;
                }
                session.markLastActivity();
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                buffer.get();
                byte major_version = buffer.get();
                byte minor_version = buffer.get();
                byte patch_version = buffer.get();
                buffer.clear();
                this.writing = true;
                this.currentState = InternalState.VERSION_RECEIVED;
                if (major_version == 1 && (minor_version == 4 || minor_version == 2)) {
                    this.result.success = true;
                    if (minor_version == 2) {
                        session.setProtocol(SupportedProtocols.V1_2);
                    }
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info(String.format("Client connected %s is using FTC %s protocol", clientAddress, major_version + "." + minor_version + "." + patch_version));
                    }
                } else {
                    if (logger.isLoggable(Level.SEVERE)) {
                        logger.severe(String.format("Client connected %s is using an unsupported version (%s) of FTC protocol", clientAddress, major_version + "." + minor_version + "." + patch_version));
                    }
                    this.result.code = ErrorCode.INVALID_VERSION;
                }
                if (session.getMaxClientsReached()) {
                    State state;
                    switch (session.getProtocol()) {
                        case V1_2: {
                            state = new tecgraf.ftc_1_4.server.states.v1_2.CloseState(ErrorCode.MAX_CLIENTS_REACHED);
                            break;
                        }
                        case V1_4: {
                            state = new CloseState(ErrorCode.MAX_CLIENTS_REACHED);
                            break;
                        }
                        default: {
                            state = new CloseState(ErrorCode.FAILURE);
                        }
                    }
                    session.setCurrentState(state);
                    return true;
                }
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean write(Session session) throws IOException {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        SocketAddress clientAddress = channel.socket().getRemoteSocketAddress();
        switch (this.currentState) {
            case VERSION_RECEIVED: {
                StateUtil.writeResultMessage(buffer, this.result);
                buffer.flip();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(String.format("Version handshake result (%s) written into buffer to connection %s", this.result, clientAddress));
                }
                this.currentState = InternalState.RESULT_MESSAGE_WRITTEN;
            }
            case RESULT_MESSAGE_WRITTEN: {
                State state;
                if (channel.write(buffer) > 0) {
                    session.markLastActivity();
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                this.writing = false;
                buffer.clear();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(String.format("Version handshake result (%s) sent successfully to %s", this.result, clientAddress));
                }
                this.currentState = InternalState.RESULT_MESSAGE_SENT;
                if (!this.result.success.booleanValue()) {
                    return false;
                }
                switch (session.getProtocol()) {
                    case V1_2: {
                        state = new tecgraf.ftc_1_4.server.states.v1_2.ValidateKeyState();
                        break;
                    }
                    case V1_4: {
                        state = new ValidateKeyState();
                        break;
                    }
                    default: {
                        state = new CloseState();
                    }
                }
                session.setCurrentState(state);
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean isWriting() {
        return this.writing;
    }

    private static enum InternalState {
        INITIAL,
        FTC_1_1_PROTOCOL_CHECKED,
        PROTOCOL_ID_RECEIVED,
        VERSION_RECEIVED,
        RESULT_MESSAGE_WRITTEN,
        RESULT_MESSAGE_SENT;

    }
}

