/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.model.algorithm.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import ibase.rest.model.algorithm.v1.Parameter;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class InputFileParameter
extends Parameter {
    private String id = null;
    private String label = null;
    private String description = null;
    private Boolean optional = null;
    private Boolean hidden = null;
    private Boolean ignoreIfHidden = null;
    private Boolean ignoreIfDisabled = null;
    private Object defaultValue = null;
    private Boolean multipleSelection = false;
    private Boolean sort = true;
    private Boolean allowsPipe = true;
    private Boolean useFilter = false;
    private CategoryEnum category = null;

    @Override
    public InputFileParameter id(String id) {
        this.id = id;
        return this;
    }

    @Override
    @ApiModelProperty(required=true, value="The identification of the parameter.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public InputFileParameter label(String label) {
        this.label = label;
        return this;
    }

    @Override
    @ApiModelProperty(value="The label of the parameter.")
    @JsonProperty(value="label")
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public InputFileParameter description(String description) {
        this.description = description;
        return this;
    }

    @Override
    @ApiModelProperty(value="The parameter description.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public InputFileParameter optional(Boolean optional) {
        this.optional = optional;
        return this;
    }

    @Override
    @ApiModelProperty(value="If the paramenter is not mandatory.")
    @JsonProperty(value="optional")
    public Boolean getOptional() {
        return this.optional;
    }

    @Override
    public void setOptional(Boolean optional) {
        this.optional = optional;
    }

    @Override
    public InputFileParameter hidden(Boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @Override
    @ApiModelProperty(value="If the paramenter is hidden.")
    @JsonProperty(value="hidden")
    public Boolean getHidden() {
        return this.hidden;
    }

    @Override
    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public InputFileParameter ignoreIfHidden(Boolean ignoreIfHidden) {
        this.ignoreIfHidden = ignoreIfHidden;
        return this;
    }

    @Override
    @ApiModelProperty(value="If the parameter is hidden, it must not be used as parameter for the algorithm execution.")
    @JsonProperty(value="ignore_if_hidden")
    public Boolean getIgnoreIfHidden() {
        return this.ignoreIfHidden;
    }

    @Override
    public void setIgnoreIfHidden(Boolean ignoreIfHidden) {
        this.ignoreIfHidden = ignoreIfHidden;
    }

    @Override
    public InputFileParameter ignoreIfDisabled(Boolean ignoreIfDisabled) {
        this.ignoreIfDisabled = ignoreIfDisabled;
        return this;
    }

    @Override
    @ApiModelProperty(value="If the parameter is disabled, it must not be used as parameter for the algorithm execution.")
    @JsonProperty(value="ignore_if_disabled")
    public Boolean getIgnoreIfDisabled() {
        return this.ignoreIfDisabled;
    }

    @Override
    public void setIgnoreIfDisabled(Boolean ignoreIfDisabled) {
        this.ignoreIfDisabled = ignoreIfDisabled;
    }

    @Override
    public InputFileParameter defaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @Override
    @ApiModelProperty(value="A json object that is the default value for this parameter. It depends of the parameter type.")
    @JsonProperty(value="default_value")
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public InputFileParameter multipleSelection(Boolean multipleSelection) {
        this.multipleSelection = multipleSelection;
        return this;
    }

    @ApiModelProperty(value="If this parameter allows multiple selection.")
    @JsonProperty(value="multiple_selection")
    public Boolean getMultipleSelection() {
        return this.multipleSelection;
    }

    public void setMultipleSelection(Boolean multipleSelection) {
        this.multipleSelection = multipleSelection;
    }

    public InputFileParameter sort(Boolean sort) {
        this.sort = sort;
        return this;
    }

    @ApiModelProperty(value="If the input files must be sorted. This option is used only if multipe_selection is true.")
    @JsonProperty(value="sort")
    public Boolean getSort() {
        return this.sort;
    }

    public void setSort(Boolean sort) {
        this.sort = sort;
    }

    public InputFileParameter allowsPipe(Boolean allowsPipe) {
        this.allowsPipe = allowsPipe;
        return this;
    }

    @ApiModelProperty(value="If the input file parameter can be used as pipe by the algorithm.")
    @JsonProperty(value="allows_pipe")
    public Boolean getAllowsPipe() {
        return this.allowsPipe;
    }

    public void setAllowsPipe(Boolean allowsPipe) {
        this.allowsPipe = allowsPipe;
    }

    public InputFileParameter useFilter(Boolean useFilter) {
        this.useFilter = useFilter;
        return this;
    }

    @ApiModelProperty(value="If a filter must be provided in the user interface.")
    @JsonProperty(value="use_filter")
    public Boolean getUseFilter() {
        return this.useFilter;
    }

    public void setUseFilter(Boolean useFilter) {
        this.useFilter = useFilter;
    }

    public InputFileParameter category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(value="If the parameter accepts a folder, a regular file or both.")
    @JsonProperty(value="category")
    public CategoryEnum getCategory() {
        return this.category;
    }

    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputFileParameter inputFileParameter = (InputFileParameter)o;
        return Objects.equals(this.id, inputFileParameter.id) && Objects.equals(this.label, inputFileParameter.label) && Objects.equals(this.description, inputFileParameter.description) && Objects.equals(this.optional, inputFileParameter.optional) && Objects.equals(this.hidden, inputFileParameter.hidden) && Objects.equals(this.ignoreIfHidden, inputFileParameter.ignoreIfHidden) && Objects.equals(this.ignoreIfDisabled, inputFileParameter.ignoreIfDisabled) && Objects.equals(this.defaultValue, inputFileParameter.defaultValue) && Objects.equals(this.multipleSelection, inputFileParameter.multipleSelection) && Objects.equals(this.sort, inputFileParameter.sort) && Objects.equals(this.allowsPipe, inputFileParameter.allowsPipe) && Objects.equals(this.useFilter, inputFileParameter.useFilter) && Objects.equals((Object)this.category, (Object)inputFileParameter.category);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.label, this.description, this.optional, this.hidden, this.ignoreIfHidden, this.ignoreIfDisabled, this.defaultValue, this.multipleSelection, this.sort, this.allowsPipe, this.useFilter, this.category});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InputFileParameter {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    optional: ").append(this.toIndentedString(this.optional)).append("\n");
        sb.append("    hidden: ").append(this.toIndentedString(this.hidden)).append("\n");
        sb.append("    ignoreIfHidden: ").append(this.toIndentedString(this.ignoreIfHidden)).append("\n");
        sb.append("    ignoreIfDisabled: ").append(this.toIndentedString(this.ignoreIfDisabled)).append("\n");
        sb.append("    defaultValue: ").append(this.toIndentedString(this.defaultValue)).append("\n");
        sb.append("    multipleSelection: ").append(this.toIndentedString(this.multipleSelection)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    allowsPipe: ").append(this.toIndentedString(this.allowsPipe)).append("\n");
        sb.append("    useFilter: ").append(this.toIndentedString(this.useFilter)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CategoryEnum {
        REGULAR("Regular"),
        FOLDER("Folder"),
        BOTH("Both");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }
    }
}

