/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.model.algorithm.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import ibase.rest.model.algorithm.v1.EnumerationItem;
import ibase.rest.model.algorithm.v1.Parameter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Configuration for the parameter of type enumeration.")
public class EnumerationParameter
extends Parameter {
    private String id = null;
    private String label = null;
    private String description = null;
    private Boolean optional = null;
    private Boolean hidden = null;
    private Boolean ignoreIfHidden = null;
    private Boolean ignoreIfDisabled = null;
    private Object defaultValue = null;
    private Boolean multipleSelection = true;
    private Boolean sort = true;
    private List<EnumerationItem> items = new ArrayList<EnumerationItem>();

    @Override
    public EnumerationParameter id(String id) {
        this.id = id;
        return this;
    }

    @Override
    @ApiModelProperty(required=true, value="The identification of the parameter.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public EnumerationParameter label(String label) {
        this.label = label;
        return this;
    }

    @Override
    @ApiModelProperty(value="The label of the parameter.")
    @JsonProperty(value="label")
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public EnumerationParameter description(String description) {
        this.description = description;
        return this;
    }

    @Override
    @ApiModelProperty(value="The parameter description.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public EnumerationParameter optional(Boolean optional) {
        this.optional = optional;
        return this;
    }

    @Override
    @ApiModelProperty(value="If the paramenter is not mandatory.")
    @JsonProperty(value="optional")
    public Boolean getOptional() {
        return this.optional;
    }

    @Override
    public void setOptional(Boolean optional) {
        this.optional = optional;
    }

    @Override
    public EnumerationParameter hidden(Boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @Override
    @ApiModelProperty(value="If the paramenter is hidden.")
    @JsonProperty(value="hidden")
    public Boolean getHidden() {
        return this.hidden;
    }

    @Override
    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public EnumerationParameter ignoreIfHidden(Boolean ignoreIfHidden) {
        this.ignoreIfHidden = ignoreIfHidden;
        return this;
    }

    @Override
    @ApiModelProperty(value="If the parameter is hidden, it must not be used as parameter for the algorithm execution.")
    @JsonProperty(value="ignore_if_hidden")
    public Boolean getIgnoreIfHidden() {
        return this.ignoreIfHidden;
    }

    @Override
    public void setIgnoreIfHidden(Boolean ignoreIfHidden) {
        this.ignoreIfHidden = ignoreIfHidden;
    }

    @Override
    public EnumerationParameter ignoreIfDisabled(Boolean ignoreIfDisabled) {
        this.ignoreIfDisabled = ignoreIfDisabled;
        return this;
    }

    @Override
    @ApiModelProperty(value="If the parameter is disabled, it must not be used as parameter for the algorithm execution.")
    @JsonProperty(value="ignore_if_disabled")
    public Boolean getIgnoreIfDisabled() {
        return this.ignoreIfDisabled;
    }

    @Override
    public void setIgnoreIfDisabled(Boolean ignoreIfDisabled) {
        this.ignoreIfDisabled = ignoreIfDisabled;
    }

    @Override
    public EnumerationParameter defaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @Override
    @ApiModelProperty(value="A json object that is the default value for this parameter. It depends of the parameter type.")
    @JsonProperty(value="default_value")
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public EnumerationParameter multipleSelection(Boolean multipleSelection) {
        this.multipleSelection = multipleSelection;
        return this;
    }

    @ApiModelProperty(value="If this parameter allows multiple selection.")
    @JsonProperty(value="multiple_selection")
    public Boolean getMultipleSelection() {
        return this.multipleSelection;
    }

    public void setMultipleSelection(Boolean multipleSelection) {
        this.multipleSelection = multipleSelection;
    }

    public EnumerationParameter sort(Boolean sort) {
        this.sort = sort;
        return this;
    }

    @ApiModelProperty(value="If the enumeration items must be sorted. This option is used only if multipe_selection is true.")
    @JsonProperty(value="sort")
    public Boolean getSort() {
        return this.sort;
    }

    public void setSort(Boolean sort) {
        this.sort = sort;
    }

    public EnumerationParameter items(List<EnumerationItem> items) {
        this.items = items;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="items")
    public List<EnumerationItem> getItems() {
        return this.items;
    }

    public void setItems(List<EnumerationItem> items) {
        this.items = items;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumerationParameter enumerationParameter = (EnumerationParameter)o;
        return Objects.equals(this.id, enumerationParameter.id) && Objects.equals(this.label, enumerationParameter.label) && Objects.equals(this.description, enumerationParameter.description) && Objects.equals(this.optional, enumerationParameter.optional) && Objects.equals(this.hidden, enumerationParameter.hidden) && Objects.equals(this.ignoreIfHidden, enumerationParameter.ignoreIfHidden) && Objects.equals(this.ignoreIfDisabled, enumerationParameter.ignoreIfDisabled) && Objects.equals(this.defaultValue, enumerationParameter.defaultValue) && Objects.equals(this.multipleSelection, enumerationParameter.multipleSelection) && Objects.equals(this.sort, enumerationParameter.sort) && Objects.equals(this.items, enumerationParameter.items);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.label, this.description, this.optional, this.hidden, this.ignoreIfHidden, this.ignoreIfDisabled, this.defaultValue, this.multipleSelection, this.sort, this.items);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EnumerationParameter {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    optional: ").append(this.toIndentedString(this.optional)).append("\n");
        sb.append("    hidden: ").append(this.toIndentedString(this.hidden)).append("\n");
        sb.append("    ignoreIfHidden: ").append(this.toIndentedString(this.ignoreIfHidden)).append("\n");
        sb.append("    ignoreIfDisabled: ").append(this.toIndentedString(this.ignoreIfDisabled)).append("\n");
        sb.append("    defaultValue: ").append(this.toIndentedString(this.defaultValue)).append("\n");
        sb.append("    multipleSelection: ").append(this.toIndentedString(this.multipleSelection)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

