/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.model.job.v2;

import ibase.rest.model.job.v2.FlowLinkTemplate;
import ibase.rest.model.job.v2.FlowNodeTemplate;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A job that executes linked algorithms.")
public class FlowTemplate {
    private String projectId = null;
    private List<FlowNodeTemplate> nodeList = new ArrayList<FlowNodeTemplate>();
    private List<FlowLinkTemplate> linkList = new ArrayList<FlowLinkTemplate>();

    public FlowTemplate projectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    @ApiModelProperty(value="The project id associated with the flow.")
    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public FlowTemplate nodeList(List<FlowNodeTemplate> nodeList) {
        this.nodeList = nodeList;
        return this;
    }

    public FlowTemplate addNodeListItem(FlowNodeTemplate nodeListItem) {
        this.nodeList.add(nodeListItem);
        return this;
    }

    @ApiModelProperty(value="List of nodes.")
    public List<FlowNodeTemplate> getNodeList() {
        return this.nodeList;
    }

    public void setNodeList(List<FlowNodeTemplate> nodeList) {
        this.nodeList = nodeList;
    }

    public FlowTemplate linkList(List<FlowLinkTemplate> linkList) {
        this.linkList = linkList;
        return this;
    }

    public FlowTemplate addLinkListItem(FlowLinkTemplate linkListItem) {
        this.linkList.add(linkListItem);
        return this;
    }

    @ApiModelProperty(value="List of links between nodes.")
    public List<FlowLinkTemplate> getLinkList() {
        return this.linkList;
    }

    public void setLinkList(List<FlowLinkTemplate> linkList) {
        this.linkList = linkList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowTemplate flowTemplate = (FlowTemplate)o;
        return Objects.equals(this.projectId, flowTemplate.projectId) && Objects.equals(this.nodeList, flowTemplate.nodeList) && Objects.equals(this.linkList, flowTemplate.linkList);
    }

    public int hashCode() {
        return Objects.hash(this.projectId, this.nodeList, this.linkList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FlowTemplate {\n");
        sb.append("    projectId: ").append(this.toIndentedString(this.projectId)).append("\n");
        sb.append("    nodeList: ").append(this.toIndentedString(this.nodeList)).append("\n");
        sb.append("    linkList: ").append(this.toIndentedString(this.linkList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

