package tecgraf.javautils.concurrent.locks;

import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;

/**
 * Modela o identificador o lock de um objeto
 */
public class LockId implements Serializable {

  /**
   * 
   */
  private static final int ID_SIZE = 10;

  /**
   * 
   */
  private byte[] value = new byte[ID_SIZE];

  /**
   * 
   */
  private int hashCode;

  /** O nome do algoritmo de gerao de nmeros pseudo-aleatrios. */
  private static final String PRNG_ALGORITHM = "SHA1PRNG";

  /**
   * Verifica a igualdade com outro objeto.
   * 
   * @param id O outro identificador a ser comparado.
   * 
   * @return Verdadeiro, se os objetos forem da mesma classe e seus valores
   *         forem iguais, ou falso caso contrrio.
   */
  @Override
  public boolean equals(Object id) {
    if (id instanceof LockId) {
      LockId anotherId = (LockId) id;
      return Arrays.equals(value, anotherId.value);
    }
    else {
      return false;
    }
  }

  /**
   * Obtm o cdigo usado para indexao em HashTable.
   * 
   * @return Um cdigo hash.
   */
  @Override
  public int hashCode() {
    return hashCode;
  }

  /**
   * Gera um cdigo hash para esse objeto. O cdigo  calculado a partir dos
   * valores presentes na chave.
   * 
   * @return Um cdigo hash.
   */
  private int generateHashCode() {
    int hashCode = 1;
    for (int i = 0; i < ID_SIZE; i++) {
      hashCode = (31 * hashCode) + (Byte.valueOf(value[i])).hashCode();
    }
    return hashCode;
  }

  /**
   * Obtm uma string que mostra os valores da chave.
   * 
   * @return Uma string com o valor da chave.
   */
  @Override
  public String toString() {
    StringBuilder str = new StringBuilder();
    for (int i = 0; i < ID_SIZE; i++) {
      str.append(value[i]);
    }
    str.append('\n');
    return str.toString();
  }

  /**
   * Constri um novo identificador usada para ser usado nos locks
   */
  public LockId() {
    SecureRandom secureRandom = null;
    try {
      secureRandom = SecureRandom.getInstance(PRNG_ALGORITHM);
    }
    catch (NoSuchAlgorithmException e) {
      secureRandom = new SecureRandom();
    }
    secureRandom.nextBytes(value);
    hashCode = generateHashCode();
  }
}
