package tecgraf.javautils.concurrent.locks;

import java.rmi.Remote;
import java.rmi.RemoteException;

/**
 * Interface observadora do estado de um objeto
 * 
 * 
 * @author Tecgraf
 */
public interface LockListener extends Remote {

  /**
   * Evento referente  obteno de um lock
   * 
   * @param objectLocked
   * @param newOwner
   * @param policy
   * @throws RemoteException
   */
  void onObjectLocked(Object objectLocked, Object newOwner, LockPolicy policy)
    throws RemoteException;

  /**
   * Evento referente  liberao de um lock
   * 
   * @param objectReleased
   * @param formerOwner
   * @param policy
   * @throws RemoteException
   */
  void onLockReleased(Object objectReleased, Object formerOwner,
    LockPolicy policy) throws RemoteException;
}
