package tecgraf.javautils.configurationmanager;

/**
 * Exceo que indica formato invlido de um valor de configurao.
 * 
 * @author Tecgraf
 */
public class IllegalFormatException extends ConfigurationManagerException {

  /** Mensagem da exceo. */
  private static final String MESSAGE =
    "A propriedade {0} da classe {1} no est no formato esperado.\nValor da propriedade: {2}.\nDetalhes:\n{3}\n";

  /** A classe que requisitou a propriedade. */
  private final Class<?> ownerClass;

  /** O nome da propriedade requisitada. */
  private final String propertyName;

  /**
   * Construtor.
   * 
   * @param ownerClass classe dona da configurao.
   * @param propertyName nome da propriedade.
   * @param value valor.
   * @param details detalhes adicionais.
   */
  public IllegalFormatException(Class<?> ownerClass, String propertyName,
    String value, String details) {
    super(MESSAGE, propertyName, ownerClass.getName(), value, details);
    this.ownerClass = ownerClass;
    this.propertyName = propertyName;
  }

  /**
   * Obtm a classe que requisitou a propriedade.
   * 
   * @return classe que requisitou a propriedade.
   */
  public Class<?> getOwnerClass() {
    return ownerClass;
  }

  /**
   * Obtm o nome da propriedade requisitada.
   * 
   * @return nome da propriedade requisitada.
   */
  public String getPropertyName() {
    return propertyName;
  }
}
