/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.launcher;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import net.miginfocom.swing.MigLayout;
import tecgraf.javautils.launcher.SplashScreen;

public class DefaultSplashScreen
extends SplashScreen {
    private JLabel messageLabel;
    private JProgressBar progressBar;

    public DefaultSplashScreen() {
        this.setDefaultCloseOperation(2);
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("", "10[grow]10", "10[grow]10[]10"));
        panel.setBackground(Color.WHITE);
        panel.add((Component)this.getMessageLabel(), "grow x, wrap");
        panel.add((Component)this.getProgressBar(), "grow x");
        this.setContentPane(panel);
        this.setSize(450, 150);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        return new Dimension(350, dim.height);
    }

    public JLabel getMessageLabel() {
        if (this.messageLabel == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setHorizontalAlignment(0);
        }
        return this.messageLabel;
    }

    public JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar();
            this.progressBar.setBorderPainted(false);
            this.progressBar.setForeground(new Color(100, 100, 255));
            this.progressBar.setBackground(Color.LIGHT_GRAY);
        }
        return this.progressBar;
    }

    @Override
    public void setMessage(String message) {
        this.getMessageLabel().setText(message);
    }

    @Override
    public void error(String message) {
        this.getMessageLabel().setText(message);
    }

    @Override
    public void setProgressBarIndeterminate(boolean indeterminate) {
        this.getProgressBar().setIndeterminate(indeterminate);
        this.getProgressBar().setValue(0);
        this.getProgressBar().setMaximum(100);
    }

    @Override
    public void setProgressBarValue(int progress) {
        this.getProgressBar().setValue(progress);
    }
}

