/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.launcher;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.nio.file.Path;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import tecgraf.javautils.launcher.Config;
import tecgraf.javautils.launcher.Environment;
import tecgraf.javautils.launcher.InstallerFrameListener;
import tecgraf.javautils.launcher.OS;

public class InstallerFrame
extends JFrame {
    private final OS os;
    private Path rootDirectory;
    private JTextField rootDirectoryField;
    private final Config config;
    private final Environment environment;
    private JTextField finalInstallDirectoryField;
    private JCheckBox shortcutCheckBox;
    private JLabel shortcutFileChooserButton;
    private JLabel shortcutTitleLabel;
    private Path shortcutDirectory;
    private JTextField shortcutDirectoryField;
    private final InstallerFrameListener listener;

    public InstallerFrame(OS os, Path rootDirectory, Config config, Path shortcutDirectory, ImageIcon icon, InstallerFrameListener listener) {
        this.os = os;
        this.rootDirectory = rootDirectory;
        this.config = config;
        this.environment = config.environment;
        this.shortcutDirectory = shortcutDirectory;
        this.listener = listener;
        if (icon != null) {
            this.setIconImage(icon.getImage());
        }
        this.setContentPane(this.getBodyPanel());
        this.setDefaultCloseOperation(3);
        this.setTitle(this.config.appName + " - Instalador");
        this.updateRootDirectoryField();
        this.updateFinalInstallDirectoryLabel();
        this.updateShortcutDirectoryField();
        this.onShortcutCheckBoxChange();
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private JPanel getBodyPanel() {
        JPanel panel = new JPanel();
        panel.setBackground(Color.WHITE);
        String rowsConfig = "[]0[]16[]0[]16[]0[]";
        if (this.os.allowsShortcut) {
            rowsConfig = rowsConfig + "16[][]0[]";
        }
        rowsConfig = rowsConfig + "16[]";
        panel.setLayout((LayoutManager)new MigLayout("", "grow", rowsConfig));
        panel.add((Component)this.getRootDirectoryTitleLabel(), "wrap");
        panel.add((Component)this.getRootDirectoryField(), "split 2, grow x");
        panel.add((Component)this.getRootDirectoryChooserButton(), "wrap");
        panel.add((Component)this.getEnvironmentTitleLabel(), "wrap");
        panel.add((Component)this.getEnvironmentField(), "wrap");
        panel.add((Component)this.getFinalInstallDirectoryTitleLabel(), "wrap");
        panel.add((Component)this.getFinalInstallDirectoryField(), "grow x, wrap");
        if (this.os.allowsShortcut) {
            panel.add((Component)this.getShortcutCheckBox(), "wrap");
            panel.add((Component)this.getShortcutTitleLabel(), "wrap");
            panel.add((Component)this.getShortcutDirectoryField(), "split 2, grow x");
            panel.add((Component)this.getShortcutDirectoryChooserButton(), "wrap");
        }
        panel.add((Component)this.getInstallButton(), "gapleft push");
        return panel;
    }

    private JLabel getRootDirectoryTitleLabel() {
        return new JLabel("Diret\u00f3rio raiz de instala\u00e7\u00e3o:");
    }

    private JLabel getEnvironmentTitleLabel() {
        return new JLabel("Ambiente:");
    }

    private JLabel getFinalInstallDirectoryTitleLabel() {
        return new JLabel("Diret\u00f3rio final de instala\u00e7\u00e3o:");
    }

    private JTextField getFinalInstallDirectoryField() {
        if (this.finalInstallDirectoryField == null) {
            this.finalInstallDirectoryField = new JTextField(40);
            this.finalInstallDirectoryField.setEditable(false);
        }
        return this.finalInstallDirectoryField;
    }

    private JTextField getShortcutDirectoryField() {
        if (this.shortcutDirectoryField == null) {
            this.shortcutDirectoryField = new JTextField();
            this.shortcutDirectoryField.setEditable(false);
        }
        return this.shortcutDirectoryField;
    }

    private void updateFinalInstallDirectoryLabel() {
        Path path = this.os.resolvePath(this.rootDirectory, this.config.appAcronym).resolve(this.environment.acronym);
        this.getFinalInstallDirectoryField().setText(path.toString());
    }

    private JTextField getEnvironmentField() {
        JTextField field = new JTextField(40);
        field.setText(this.environment.toString());
        field.setEditable(false);
        return field;
    }

    private JTextField getRootDirectoryField() {
        if (this.rootDirectoryField == null) {
            this.rootDirectoryField = new JTextField(40);
            this.rootDirectoryField.setEditable(false);
        }
        return this.rootDirectoryField;
    }

    private JLabel getRootDirectoryChooserButton() {
        JLabel button = new JLabel();
        URL url = InstallerFrame.class.getResource("/folder_icon_24.png");
        if (url != null) {
            ImageIcon icon = new ImageIcon(url);
            button.setIcon(icon);
        }
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    InstallerFrame.this.onRootDirectoryChoose();
                }
            }
        });
        return button;
    }

    private void onShortcutCheckBoxChange() {
        boolean enabled = this.getShortcutCheckBox().isSelected();
        this.getShortcutDirectoryField().setEnabled(enabled);
        this.getShortcutDirectoryChooserButton().setEnabled(enabled);
        this.getShortcutTitleLabel().setEnabled(enabled);
    }

    private void onRootDirectoryChoose() {
        int option;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        if (this.rootDirectory != null) {
            fileChooser.setCurrentDirectory(this.rootDirectory.toFile());
        }
        if ((option = fileChooser.showOpenDialog(this)) == 0) {
            this.rootDirectory = fileChooser.getSelectedFile().toPath();
            this.updateRootDirectoryField();
        }
    }

    private void updateRootDirectoryField() {
        if (this.rootDirectory == null) {
            this.getRootDirectoryField().setText("");
        } else {
            this.getRootDirectoryField().setText(this.rootDirectory.toString());
        }
        this.updateFinalInstallDirectoryLabel();
    }

    private JCheckBox getShortcutCheckBox() {
        if (this.shortcutCheckBox == null) {
            this.shortcutCheckBox = new JCheckBox("Instalar atalho na \u00e1rea de trabalho");
            this.shortcutCheckBox.setOpaque(false);
            this.shortcutCheckBox.setSelected(true);
            this.shortcutCheckBox.addActionListener(e -> this.onShortcutCheckBoxChange());
        }
        return this.shortcutCheckBox;
    }

    private JLabel getShortcutDirectoryChooserButton() {
        if (this.shortcutFileChooserButton == null) {
            this.shortcutFileChooserButton = new JLabel();
            URL url = InstallerFrame.class.getResource("/folder_icon_24.png");
            if (url != null) {
                ImageIcon icon = new ImageIcon(url);
                this.shortcutFileChooserButton.setIcon(icon);
            }
            this.shortcutFileChooserButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 1) {
                        InstallerFrame.this.onShortcutDirectoryChoose();
                    }
                }
            });
        }
        return this.shortcutFileChooserButton;
    }

    private JLabel getShortcutTitleLabel() {
        if (this.shortcutTitleLabel == null) {
            this.shortcutTitleLabel = new JLabel("Atalho ser\u00e1 criado em:");
        }
        return this.shortcutTitleLabel;
    }

    private void onShortcutDirectoryChoose() {
        int option;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        if (this.shortcutDirectory != null) {
            fileChooser.setCurrentDirectory(this.shortcutDirectory.toFile());
        }
        if ((option = fileChooser.showOpenDialog(this)) == 0) {
            this.shortcutDirectory = fileChooser.getSelectedFile().toPath();
            this.updateShortcutDirectoryField();
        }
    }

    private void updateShortcutDirectoryField() {
        if (this.shortcutDirectory == null) {
            this.getShortcutDirectoryField().setText("");
        } else {
            this.getShortcutDirectoryField().setText(this.shortcutDirectory.toString());
        }
    }

    private JButton getInstallButton() {
        JButton button = new JButton("Instalar");
        button.addActionListener(e -> this.onInstall());
        return button;
    }

    private void onInstall() {
        if (this.os.allowsShortcut && this.getShortcutCheckBox().isSelected() && this.shortcutDirectory == null) {
            JOptionPane.showMessageDialog(null, this.config.requiredShortcutDirectory, "Aten\u00e7\u00e3o", 2);
            return;
        }
        this.dispose();
        if (this.listener != null) {
            if (this.getShortcutCheckBox().isSelected()) {
                this.listener.onInstall(this.rootDirectory, this.shortcutDirectory);
            } else {
                this.listener.onInstall(this.rootDirectory, null);
            }
        }
    }
}

