/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.launcher;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.nio.file.Path;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import net.miginfocom.swing.MigLayout;
import tecgraf.javautils.launcher.Config;
import tecgraf.javautils.launcher.InstallerSuccessFrameListener;
import tecgraf.javautils.launcher.Replacement;

public class InstallerSuccessFrame
extends JFrame {
    private final Config config;
    private final Path launcherPath;
    private final Path shortcutPath;
    private final boolean shortcutError;
    private final InstallerSuccessFrameListener listener;

    public InstallerSuccessFrame(Config config, ImageIcon icon, Path launcherPath, Path shortcutPath, boolean shortcutError, InstallerSuccessFrameListener listener) {
        this.config = config;
        this.launcherPath = launcherPath;
        this.shortcutPath = shortcutPath;
        this.shortcutError = shortcutError;
        this.listener = listener;
        if (icon != null) {
            this.setIconImage(icon.getImage());
        }
        this.setContentPane(this.getBodyPanel());
        this.setDefaultCloseOperation(3);
        this.setTitle(config.appName + " - Instalador");
        this.setSize(450, 250);
        this.setLocationRelativeTo(null);
    }

    private JPanel getBodyPanel() {
        JPanel panel = new JPanel();
        panel.setBackground(Color.WHITE);
        String rowsConfig = "[]16[]";
        if (this.shortcutPath != null) {
            rowsConfig = rowsConfig + "16[]";
        }
        rowsConfig = rowsConfig + "16:push[]";
        panel.setLayout((LayoutManager)new MigLayout("", "[grow]", rowsConfig));
        panel.add((Component)this.buildTextArea(this.config.successInstallTitle), "wmin 0, grow x, wrap");
        String message = this.applyReplacements(this.config.successInstallMessage);
        panel.add((Component)this.buildTextArea(message), "wmin 0, grow x, wrap");
        if (this.shortcutPath != null) {
            String shortcutMessage = "";
            shortcutMessage = this.shortcutError ? this.applyReplacements(this.config.failureShortcutMessage) : this.applyReplacements(this.config.successShortcutMessage);
            panel.add((Component)this.buildTextArea(shortcutMessage), "wmin 0, grow x, wrap");
        }
        panel.add((Component)this.buildExecuteButton(), "gapleft push, split 2");
        panel.add((Component)this.buildCloseButton(), "gapleft 8");
        return panel;
    }

    private JComponent buildTextArea(String message) {
        JTextPane textArea = new JTextPane();
        textArea.setEditable(false);
        textArea.setContentType("text/html");
        textArea.setText(message);
        return textArea;
    }

    private String applyReplacements(String message) {
        if (message == null) {
            return "";
        }
        if (this.shortcutPath != null) {
            message = Replacement.SHORTCUT_PATH.replace(message, this.shortcutPath.toString());
        }
        message = Replacement.LAUNCHER_PATH.replace(message, this.launcherPath.toString());
        message = Replacement.APP_PATH.replace(message, this.launcherPath.getParent().toString());
        return message;
    }

    private JButton buildCloseButton() {
        JButton button = new JButton("Fechar");
        button.addActionListener(e -> System.exit(0));
        return button;
    }

    private JButton buildExecuteButton() {
        JButton button = new JButton(this.config.executeAppButtonText);
        button.addActionListener(e -> this.listener.onExecute());
        return button;
    }
}

