/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.launcher;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.xml.bind.DatatypeConverter;
import org.json.JSONArray;
import org.json.JSONObject;
import tecgraf.javautils.launcher.Base;
import tecgraf.javautils.launcher.Config;
import tecgraf.javautils.launcher.FileType;
import tecgraf.javautils.launcher.OS;
import tecgraf.javautils.launcher.Replacement;
import tecgraf.javautils.launcher.SplashScreen;

public class Launcher
extends Base {
    private static final String PROTOCOL_VERSION = "5";
    private static final String ARG_LAUNCHER_DEBUG = "launcher-debug";
    private static final String ARG_LAUNCHER_CACHED = "launcher-cached";
    private static final String ARG_LAUNCHER_OMIT_PARAMETERS = "launcher-omit-parameters";
    public static final String APP_VISIBLE_MARKER = "APP-VISIBLE";
    private static final String APP_EXE_ERROR_MSG = "Ocorreu um erro ao executar a aplica\u00e7\u00e3o: ";
    private boolean debugMode = false;
    private String debugPort = null;
    private boolean cachedMode = false;
    private boolean omitParameters = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute(String[] args, Config config, OS os) {
        logger.info("Atualizando a aplica\u00e7\u00e3o");
        if (args.length > 0) {
            logger.info(() -> "Argumentos recebidos: " + args.length);
        } else {
            logger.info(() -> "Nenhum argumento recebido.");
        }
        SplashScreen splashScreen = this.buildSplashScreen(config);
        if (splashScreen != null) {
            SwingUtilities.invokeLater(() -> {
                splashScreen.setProgressBarIndeterminate(true);
                splashScreen.setVisible(true);
            });
        }
        try {
            Path parametersFile;
            Path appJarFile;
            Path environmentDir;
            try {
                Path executingJar = Paths.get(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI().getPath(), new String[0]);
                environmentDir = executingJar.getParent();
            }
            catch (Exception e) {
                logger.severe("N\u00e3o foi poss\u00edvel descobrir o diret\u00f3rio do JAR em execu\u00e7\u00e3o: " + e.getMessage() + ". Ser\u00e1 utilizado o workingDirectory do Java.");
                environmentDir = Paths.get(System.getProperty("user.dir"), new String[0]);
            }
            logger.info("environmentDirectory: " + environmentDir);
            if (!Files.exists(environmentDir, new LinkOption[0])) {
                throw new IllegalStateException("Diret\u00f3rio inexistente: " + environmentDir);
            }
            this.setFileLogger(environmentDir.resolve("launcher.log"));
            ArrayList<String> receivedParameters = new ArrayList<String>();
            for (String arg : args) {
                if (arg.startsWith(ARG_LAUNCHER_DEBUG)) {
                    String[] debugArg = arg.split(":");
                    if (debugArg.length != 2) continue;
                    this.setDebugMode(true, debugArg[1]);
                    continue;
                }
                if (arg.equals(ARG_LAUNCHER_CACHED)) {
                    this.setCachedMode(true);
                    continue;
                }
                if (arg.equals(ARG_LAUNCHER_OMIT_PARAMETERS)) {
                    this.setOmitParameters(true);
                    continue;
                }
                receivedParameters.add(arg);
            }
            if (!this.cachedMode) {
                if (splashScreen != null) {
                    SwingUtilities.invokeLater(() -> splashScreen.setMessage("Atualizando a aplica\u00e7\u00e3o..."));
                }
                logger.info("Verificando se exista atualiza\u00e7\u00e3o para a aplica\u00e7\u00e3o...");
                appJarFile = this.updateFile(splashScreen, environmentDir, config, FileType.APP);
                parametersFile = this.updateFile(splashScreen, environmentDir, config, FileType.PARAMETERS);
            } else {
                logger.config(() -> "Modo cached ativado");
                appJarFile = this.getLastFile(environmentDir, FileType.APP);
                parametersFile = this.getLastFile(environmentDir, FileType.PARAMETERS);
                if (appJarFile == null) {
                    throw new IllegalStateException("Ocorreu um erro ao executar a aplica\u00e7\u00e3o: ERROR-007");
                }
            }
            logger.info("Abrindo a aplica\u00e7\u00e3o...");
            if (splashScreen != null) {
                SwingUtilities.invokeLater(() -> splashScreen.setMessage("Abrindo a aplica\u00e7\u00e3o..."));
            }
            ArrayList<String> command = new ArrayList<String>();
            Collections.addAll(command, JAR_CMD);
            if (this.debugMode && this.debugPort != null) {
                logger.config(() -> "Modo debug ativo na porta " + this.debugPort);
                String debugValue = String.format(String.format("Par\u00e2metro de debug: -agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=%s", this.debugPort), new Object[0]);
                logger.config(() -> debugValue);
                command.add(debugValue);
            }
            command.add(appJarFile.toString());
            ArrayList<String> params = new ArrayList<String>();
            params.addAll(this.buildParameters(parametersFile, config, this.debugMode));
            params.addAll(receivedParameters);
            LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
            params.forEach(param -> paramsMap.put(param.split(" ")[0], Launcher.getArgValue(param)));
            ArrayList<String> appParams = new ArrayList<String>(command);
            paramsMap.forEach((key, value) -> appParams.add(key + " " + value));
            logger.info(() -> "Carregando par\u00e2metros recebidos...");
            if (this.omitParameters) {
                logger.config(() -> "Par\u00e2metros recebidos omitidos.");
            } else {
                this.printParameters(appParams);
            }
            ProcessBuilder builder = new ProcessBuilder(appParams);
            Process process = builder.start();
            StreamLogger errorReader = new StreamLogger(splashScreen, process.getErrorStream());
            errorReader.start();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = br.readLine()) != null) {
                    if (line.equals(APP_VISIBLE_MARKER)) {
                        break;
                    }
                    logger.info("App output: " + line);
                }
            }
            errorReader.stopLogger();
        }
        catch (Exception e) {
            Launcher.logException(e);
            this.showErrorAndExit(e.getMessage());
        }
        finally {
            if (splashScreen != null) {
                SwingUtilities.invokeLater(splashScreen::dispose);
            }
        }
    }

    private static String getArgValue(String arg) {
        String[] splitArgs = arg.split(" ");
        if (splitArgs.length > 1) {
            return splitArgs[1];
        }
        return "";
    }

    private void printParameters(List<String> parameters) {
        StringJoiner stringJoiner = new StringJoiner(" ");
        parameters.forEach(param -> logger.info(() -> "Par\u00e2metro: " + param));
        parameters.forEach(stringJoiner::add);
        logger.info(() -> "Executando: " + stringJoiner);
    }

    private Path updateFile(SplashScreen splashScreen, Path environmentDir, Config config, FileType fileType) throws Exception {
        Path file;
        String storageRootUrl = config.environment.storageUrl;
        List<Path> filesInDirectory = this.getFilesInDirectory(environmentDir, fileType);
        if (filesInDirectory.size() > 0) {
            logger.info((Object)((Object)fileType) + " localizado no diret\u00f3rio.");
            file = filesInDirectory.get(filesInDirectory.size() - 1);
            String correctMd5 = this.getMd5FromUrl(storageRootUrl + fileType.md5filename());
            logger.info("MD5 esperado: " + correctMd5);
            logger.info("Gerando MD5 do arquivo...");
            String md5File = this.getMd5(file).toLowerCase();
            logger.info("MD5 do arquivo: " + md5File);
            if (correctMd5.equals(md5File)) {
                logger.info("MD5 correto");
                return file;
            }
            logger.info("MD5s n\u00e3o s\u00e3o iguais");
        }
        if (filesInDirectory.size() > 0) {
            logger.info("Apagando arquivos antigos...");
            for (Path oldFile : filesInDirectory) {
                logger.info("Apagando: " + oldFile.toString());
                try {
                    Files.delete(oldFile);
                }
                catch (Exception e) {
                    logger.info("Erro ao apagar o arquivo: " + oldFile);
                }
            }
        }
        logger.info("Atualizando vers\u00e3o...");
        file = environmentDir.resolve(fileType.filenameWithTimestamp());
        this.download(splashScreen, storageRootUrl + fileType.filename(), file);
        logger.info("Download do arquivo atualizado realizado com sucesso.");
        return file;
    }

    private List<Path> getFilesInDirectory(Path rootInstallDir, FileType fileType) throws IOException {
        return Files.list(rootInstallDir).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().toLowerCase().startsWith(fileType.prefix)).filter(path -> path.getFileName().toString().toLowerCase().endsWith(fileType.extension)).sorted().collect(Collectors.toList());
    }

    private Path getLastFile(Path dir, FileType fileType) throws IOException {
        List<Path> jars = this.getFilesInDirectory(dir, fileType);
        return jars.isEmpty() ? null : jars.get(jars.size() - 1);
    }

    private String getMd5FromUrl(String md5Url) {
        logger.info("Obtendo MD5 de '" + md5Url + "'...");
        try {
            String inputLine;
            URL url = new URL(md5Url);
            URLConnection connection = url.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            return response.toString().toLowerCase();
        }
        catch (Exception e) {
            throw new IllegalStateException("N\u00e3o foi poss\u00edvel obter o md5: " + md5Url, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getMd5(Path path) {
        try (FileInputStream fis = new FileInputStream(path.toFile());){
            int nread;
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] dataBytes = new byte[1024];
            while ((nread = fis.read(dataBytes)) != -1) {
                md.update(dataBytes, 0, nread);
            }
            byte[] mdbytes = md.digest();
            String string = DatatypeConverter.printHexBinary((byte[])mdbytes);
            return string;
        }
        catch (Exception e) {
            throw new IllegalStateException("N\u00e3o foi poss\u00edvel obter o md5: " + path.toString(), e);
        }
    }

    private List<String> buildParameters(Path parametersFile, Config config, boolean print) throws IOException, InterruptedException, InvocationTargetException {
        ArrayList<String> params = new ArrayList<String>();
        logger.info(() -> "Carregando configura\u00e7\u00e3o padr\u00e3o de par\u00e2metros...");
        Charset charset = StandardCharsets.UTF_8;
        if (config.parametersChartset != null) {
            logger.info("Instanciando chartset: " + config.parametersChartset);
            try {
                charset = Charset.forName(config.parametersChartset);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erro ao instanciar chartset", e);
                charset = StandardCharsets.UTF_8;
            }
        }
        logger.info("Chartset utilizado: " + charset.name());
        StringBuilder paramJson = new StringBuilder();
        for (String line : Files.readAllLines(parametersFile, charset)) {
            paramJson.append(line);
        }
        JSONObject paramsJsonObject = new JSONObject(paramJson.toString());
        String protocolVersion = paramsJsonObject.getString("protocolVersion");
        if (!PROTOCOL_VERSION.equals(protocolVersion)) {
            String wrongProtocolVersionMessage = paramsJsonObject.getString("wrongProtocolVersionMessage");
            SwingUtilities.invokeAndWait(() -> JOptionPane.showMessageDialog(null, wrongProtocolVersionMessage, config.appAcronym, 2));
            System.exit(0);
        }
        JSONObject environments = paramsJsonObject.getJSONObject("environments");
        JSONArray envArray = environments.getJSONArray(config.environment.acronym);
        for (int i = 0; i < envArray.length(); ++i) {
            String param = envArray.getString(i);
            param = Replacement.LAUNCHER_ENV.replace(param, config.environment.acronym);
            param = Replacement.LAUNCHER_VERSION.replace(param, this.getVersion());
            params.add(param);
            if (!print) continue;
            logger.config("par\u00e2metro " + (i + 1) + ": " + param);
        }
        logger.info(() -> "Configura\u00e7\u00e3o padr\u00e3o de par\u00e2metros finalizada.");
        return params;
    }

    public void setCachedMode(boolean cachedMode) {
        this.cachedMode = cachedMode;
    }

    public void setDebugMode(boolean enable, String port) {
        this.debugPort = port;
        this.debugMode = enable;
    }

    public void setOmitParameters(boolean enable) {
        this.omitParameters = enable;
    }

    public static void main(String[] args) {
        Launcher launcher = new Launcher();
        launcher.start(args);
    }

    static class StreamLogger
    extends Thread {
        final SplashScreen splashScreen;
        final InputStream errorStream;
        volatile boolean runThread = true;
        private static final long SLEEP_TIMER = 250L;

        StreamLogger(SplashScreen splashScreen, InputStream errorStream) {
            this.splashScreen = splashScreen;
            this.errorStream = errorStream;
        }

        public void stopLogger() {
            this.runThread = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean hasError = false;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(this.errorStream));){
                while (this.runThread) {
                    if (br.ready()) {
                        String line = br.readLine();
                        if (line == null) {
                            break;
                        }
                        Base.logger.severe(line);
                        hasError = true;
                    }
                    Thread.sleep(250L);
                }
            }
            catch (IOException ioe) {
                Base.logException(ioe);
            }
            catch (InterruptedException ie) {
                Base.logException(ie);
                Thread.currentThread().interrupt();
            }
            finally {
                if (hasError) {
                    this.splashScreen.dispose();
                    SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(null, "Erro ao abrir a aplica\u00e7\u00e3o", "Erro", 0));
                }
            }
        }
    }
}

