package tecgraf.javautils.sparkserver.library.utils;

import tecgraf.javautils.sparkserver.library.exceptions.JuBadRequestException;

import spark.Request;

public class JuRequestUtilities {

  public static String getRequestParameter(Request request, String parameterName, boolean required) throws JuBadRequestException {
    if (parameterName == null || parameterName.isEmpty()) {
      final String err = "parameter name cannot be null.";
      throw new IllegalArgumentException(err);
    }
    final String param = request.params(parameterName);
    if (required && param == null) {
      throw new JuBadRequestException("No parameter found: " + parameterName);
    }
    return param;
  }

  public static String getHeaderParameter(Request request, String parameterName, boolean required) throws JuBadRequestException {
    if (parameterName == null || parameterName.isEmpty()) {
      final String err = "parameter name cannot be null.";
      throw new IllegalArgumentException(err);
    }
    final String param = request.headers(parameterName);
    if (required && param == null) {
      throw new JuBadRequestException("No parameter found: " + parameterName);
    }
    return param;
  }

  public static String getQueryParameter(Request request, String parameterName, boolean required) throws JuBadRequestException{
    if (parameterName == null || parameterName.isEmpty()) {
      final String err = "parameter name cannot be null.";
      throw new IllegalArgumentException(err);
    }
    final String param = request.queryParams(parameterName);
    if (required && param == null) {
      throw new JuBadRequestException("No parameter found: " + parameterName);
    }
    return param;
  }
}
