/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.sparkserver.library.standard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tecgraf.javautils.sparkserver.library.core.JuIWebSocketClass;

@WebSocket
public abstract class JuWebSocketClass
implements JuIWebSocketClass {
    private static final Map<Class<? extends JuWebSocketClass>, List<Session>> sessionsMap = new HashMap<Class<? extends JuWebSocketClass>, List<Session>>();

    @Override
    public abstract void connected(Session var1);

    @Override
    public abstract void closed(Session var1, int var2, String var3);

    @Override
    public abstract void messageReceived(Session var1, String var2);

    protected void broadcastString(String value) {
        this.getAllSessions().parallelStream().forEach(s -> this.sendString((Session)s, value));
    }

    protected void sendString(Session session, String message) {
        Logger logger = this.getLogger();
        try {
            session.getRemote().sendString(message);
            logger.info("Sent: " + session + " -- " + message);
        }
        catch (IOException e) {
            logger.error("Send failure: " + message, (Throwable)e);
        }
    }

    @OnWebSocketConnect
    public final void _connected(Session session) {
        this.addSession(session);
        this.connected(session);
        this.getLogger().info("Connected: " + session);
    }

    @OnWebSocketClose
    public final void _closed(Session session, int statusCode, String reason) {
        this.removeSession(session);
        this.closed(session, statusCode, reason);
        Logger logger = this.getLogger();
        logger.info("Closed: " + session + " -- " + statusCode + " -- " + reason);
    }

    @OnWebSocketMessage
    public final void _messageReceived(Session session, String message) {
        this.messageReceived(session, message);
        Logger logger = this.getLogger();
        logger.info("Received: " + session + " -- " + message);
    }

    @Override
    public Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    private List<Session> getAllSessions() {
        Class<?> clazz = this.getClass();
        List<Session> sessions = sessionsMap.get(clazz);
        if (sessions == null) {
            sessionsMap.put(clazz, new ArrayList());
        }
        return sessionsMap.get(clazz);
    }

    private synchronized void addSession(Session session) {
        List<Session> sessions = this.getAllSessions();
        sessions.add(session);
    }

    private synchronized void removeSession(Session session) {
        List<Session> sessions = this.getAllSessions();
        sessions.remove(session);
    }
}

